﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using SLExtensions.Input;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Data.Models;
using System.Collections.Generic;
using System.Linq;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ConsultMenuVM : BaseMVVM.ViewModel.ViewModel
    {
      private List<VideoBook> _videoBooks = new List<VideoBook>();
      private List<VideoBook> list = new List<VideoBook>();
      public List<VideoBook> VideoBooks
      {
          get 
          {
              _videoBooks.Sort(new VideoBookComparer());
              if (SearchWord != String.Empty)
              {
                  return list;
              }
              else
              {
                  return _videoBooks;
              }
          
          }
          set
          {
              list = value;
              OnPropertyChanged("VideoBooks");
          }
      }

      public bool SearchAuthor { get; set; }
      public bool SearchContributer { get; set; }
      public bool SearchTag { get; set; }

      private String _searchWord= "";
      public String SearchWord 
      { 
          get
          {
              return _searchWord;
          }
          
          set 
          {
              _searchWord = value;
              OnPropertyChanged("SearchWord");
          } 
      }
     
        public ConsultMenuVM()
        {
            SearchAuthor = true;
          InitializeCommands();
        }

        private void InitializeCommands()
        {
           Commands.ConsultMenu.GetBook.Executed += new EventHandler<ExecutedEventArgs>(GetBook_Executed);
         }
        public ConsultMenuVM(List<VideoBook> argList)
        {
            _videoBooks = argList;
            SearchAuthor = true;
            InitializeCommands();
        }

        

        void GetBook_Executed(object sender, ExecutedEventArgs e)
        {
           
           if (SearchAuthor)
            {
                var query = from c in _videoBooks
                            where c.Author.UserName.Contains(_searchWord)
                            select c;
                VideoBooks = query.ToList();
            }
            if (SearchContributer)
            {
                List<VideoBook> temp = new List<VideoBook>();
                foreach (VideoBook Book in _videoBooks)
                {
                    foreach (VideoChapter Chapter in Book.Chapters)
                    {
                        foreach (Annotation Annotation in Chapter.Annotations)
                        {
                            if ( Annotation.Contributer.UserName.Contains(_searchWord))
                            {
                                temp.Add(Book);
                            }
                        }
                    }
                }
                VideoBooks = temp;
            }
            if(SearchTag)
            {
                List<VideoBook> temp = new List<VideoBook>();
                foreach (VideoBook Book in _videoBooks)
                {
                    foreach (VideoChapter Chapter in Book.Chapters)
                    {
                        foreach (Annotation Annotation in Chapter.Annotations)
                        {
                            if (Annotation.Tags.Contains(_searchWord))
                            {
                                temp.Add(Book);
                            }
                        }
                        foreach (SegmentIndex Segment in Chapter.Index)
                        {
                            if (Segment.Tags.Contains(_searchWord))
                            {
                                temp.Add(Book);
                            }
                        }
                    }
                }
                VideoBooks = temp;
            }
        }
       
    }
}
