﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class VideoViewerVM : BaseMVVM.ViewModel.ViewModel
    {

        private String _source;
        public String Source
        {
            get
            {
                return _source;
            }
            set
            {
                _source = value;
               
                OnPropertyChanged(null);
            }
        }
        public Uri USource
        {
            get
            {
                if (Source != null)
                {
                    return new Uri(Source, UriKind.RelativeOrAbsolute);
                }
                else
                {
                    return null;
                }
            }

        }
        
        public String Info
        {
            get
            {
                return position + ":" + Source;
            }
            
        }
        
        private TimeSpan position = new TimeSpan(0,0,0);
        public TimeSpan Position
        {
            get
            {
                return position;
            }
            set
            {
                position = value;
                //OnPropertyChanged("Position");
               OnPropertyChanged("Info");
            
            }
        }

        private bool _playControl;
        public bool PlayControl
        {
            get
            {
                return _playControl;
            }
            set
            {
                _playControl = value;
                OnPropertyChanged("PlayControl");
            }
        }

        private bool _recordControl;
        public bool RecordControl
        {
            get
            {
                return _recordControl;
            }
            set
            {
                _recordControl = value;
                OnPropertyChanged("RecordControl");
            }
        }
        public VideoViewerVM(bool playControl,bool recordControl )
        {
            _playControl = playControl;
            _recordControl = recordControl;
            InitializeCommands();
        }
        public event EventHandler<VideoViewerVMEventArgs> Tick;

        private void InitializeCommands()
        {
           
        }
        public void GoTo(TimeSpan pos)
        {
            Position = pos;
            Commands.GoToTime.Execute(Position,this);
        }
        public void LaunchTick(TimeSpan Pos)
        {
            if(Tick!=null)
            {
                Tick(this, new VideoViewerVMEventArgs(Pos));
            }
        }
       

    }
    public class VideoViewerVMEventArgs : EventArgs
    {
        public TimeSpan Position { get; set; }
        public VideoViewerVMEventArgs(TimeSpan pos)
        {
            Position = pos;
        }
    }
}
