﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using Iri.Modernisation.Data.Models;
using System.Collections.ObjectModel;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ProductionViewVM : BaseMVVM.ViewModel.ViewModel
    {

        private VideoSequence _selectedVideoSequence;
        public VideoSequence SelectedVideoSequence
        {
            get
            {
                return _selectedVideoSequence;
            }
            set
            {
                _selectedVideoSequence = value;
                ViewModelProductionEditor = new ProductionEditorVM(value);
                OnPropertyChanged("SelectedVideoSequence");
               
            }
        }

        private ObservableCollection<VideoSequence> _recordedVideoSequences;
        public ObservableCollection<VideoSequence> RecordedVideoSequences
        {
            get
            {
                return _recordedVideoSequences;
            }
            set
            {
                _recordedVideoSequences = value;
                OnPropertyChanged("RecordedVideoSequences");
            }
        }


        private HeaderProductionVM _headerProductionVM;
        public HeaderProductionVM ViewModelHeaderProduction
        {
            get
            {
                return _headerProductionVM;
            }
            set
            {
                _headerProductionVM = value;
                OnPropertyChanged("ViewModelHeaderProduction");
            }
        }
        private ProductionTimeLineVM _productionTimeLineVM;
        public ProductionTimeLineVM ViewModelProductionTimeLine
        {
            get
            {
                return _productionTimeLineVM;
            }
            set
            {
                _productionTimeLineVM = value;
                OnPropertyChanged("ViewModelProductionTimeLine");
            }
        }

        private ProductionEditorVM _productionEditorVM;
        public ProductionEditorVM ViewModelProductionEditor
        {
            get
            {
                return _productionEditorVM;
            }
            set
            {
                _productionEditorVM = value;
                OnPropertyChanged("ViewModelProductionEditor");
            }
        }

        private VideoViewerVM _masterVideoViewerVM;
        public VideoViewerVM ViewModelMasterVideoViewer
        {
            get
            {
                return _masterVideoViewerVM;
            }
            set
            {
                _masterVideoViewerVM = value;
                OnPropertyChanged("ViewModelMasterVideoViewer");
            }
        }
        
        //SelectedChapter
        public ProductionViewVM()
        {
            RecordedVideoSequences = new ObservableCollection<VideoSequence>();
            ViewModelHeaderProduction = new HeaderProductionVM();
            ViewModelProductionTimeLine = new ProductionTimeLineVM();
            ViewModelProductionEditor = new ProductionEditorVM();
            ViewModelMasterVideoViewer = new VideoViewerVM(true, false);
           // ViewModelMasterVideoViewer.Source = Application.Current.Host.Source.Host.ToString() + "/video.mp4";
            
            ViewModelProductionTimeLine.ViewModelVideoViewer = ViewModelMasterVideoViewer;
            Commands.ProductionView.ClickAddSelectedRecord.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickAddSelectedRecord_Executed);
            Random rndNumbers = new Random();
            for (int i = 0; i < 10; i++)
            {
         
                _recordedVideoSequences.Add(new VideoSequence()
                {
                    Path= Application.Current.Host.Source.Host.ToString()+"/video.mp4",
                    RunTime = new TimeSpan(0, rndNumbers.Next(10, 60), 0),
                    BeginTrim = new TimeSpan(0, 0, 0),
                    EndTrim = new TimeSpan(0, 0, 0),
                });
            }
            ViewModelProductionTimeLine.SwitchVideo += new EventHandler<ProductionTimeLineVMEventArgs>(ViewModelProductionTimeLine_SwitchVideo);   
            ViewModelMasterVideoViewer.Tick += new EventHandler<VideoViewerVMEventArgs>(ViewModelMasterVideoViewer_Tick);
           
        }

        void ViewModelProductionTimeLine_SwitchVideo(object sender, ProductionTimeLineVMEventArgs e)
        {
            ViewModelMasterVideoViewer.Source = (e.VideoSequence.Path);
            ViewModelMasterVideoViewer.GoTo(e.BeginAt);
        }

        void ViewModelMasterVideoViewer_Tick(object sender, VideoViewerVMEventArgs e)
        {
            double newPos = ViewModelProductionTimeLine.ActualVideoSequence.TimerIn.TotalMilliseconds+e.Position.TotalMilliseconds;
            if (ViewModelProductionTimeLine.ActualVideoSequence.TimerOut.TotalMilliseconds <= newPos)
            {
                ViewModelProductionTimeLine.ActualVideoSequence = ViewModelProductionTimeLine.TimeLine[ViewModelProductionTimeLine.TimeLine.IndexOf(ViewModelProductionTimeLine.ActualVideoSequence) + 1];
                ViewModelMasterVideoViewer.Source = ViewModelProductionTimeLine.ActualVideoSequence.Path;
                ViewModelMasterVideoViewer.GoTo(TimeSpan.Zero);
            }
            ViewModelProductionTimeLine.Position = newPos;
        }

        void ClickAddSelectedRecord_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (ViewModelProductionTimeLine.SelectedChapter != -1)
            {
                if (!ViewModelProductionTimeLine.IsIndexing)
                {
                    if (SelectedVideoSequence != null)
                    {
                        ViewModelMasterVideoViewer.Source = SelectedVideoSequence.Path;

                        VideoSequence newVideo = new VideoSequence(SelectedVideoSequence);
                        ViewModelProductionTimeLine.ActualVideoSequence = newVideo;
                            ViewModelProductionTimeLine.SelectedVideoSequences.Add(newVideo);
                            ViewModelProductionTimeLine.Position = ViewModelProductionTimeLine.TimeLine[ViewModelProductionTimeLine.TimeLine.Count - 1].TimerIn.TotalMilliseconds;
                    }
                }
               
            }
         
           
        }
       
       
    }
}
