﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Data.LDTClass;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ConsultationViewVM : BaseMVVM.ViewModel.ViewModel
    {
        private PolemicElement _selectedElement;
        public PolemicElement SelectedElement
        {
            get
            {
                return _selectedElement;
            }
            set
            {
                _selectedElement = value;
                OnPropertyChanged("SelectedElement");
            }
        }



        private SLExtensions.Collections.ObjectModel.ObservableCollection<BookTimeLineVM> _selectedVideoBooks;
        public SLExtensions.Collections.ObjectModel.ObservableCollection<BookTimeLineVM> SelectedVideoBooks
        {
            get
            {

                return _selectedVideoBooks;
            }
            set
            {
                _selectedVideoBooks = value;
                OnPropertyChanged("SelectedVideoBooks");
            }
        }

        private int _selectedVideoBookIndex=-1;
        public int SelectedVideoBookIndex
        {
            get
            {
                return _selectedVideoBookIndex;
            }
            set
            {
                _selectedVideoBookIndex= value;
                OnPropertyChanged("SelectedVideoBookIndex");
                ConsultationBookViewContextMenu.SelectedBookVM = (_selectedVideoBooks[value]);
               
            }
        }

        private ConsultationBookViewVM _consultationBookViewContextMenu;
        public ConsultationBookViewVM ConsultationBookViewContextMenu
        {
            get
            {
                return _consultationBookViewContextMenu;
            }
            set
            {
                _consultationBookViewContextMenu = value;
                OnPropertyChanged(null);
            }
        }

        private void InitializeCommands()
        {
            Commands.ConsultMenu.ClickBook.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickBook_Executed);
            Commands.PolemicElement.SelectPolemicElement.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(SelectPolemicElement_Executed);
       
            Commands.ClickMenu.CreateNewTextualAnnotation.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CreateNewTextualAnnotation_Executed);
        }

        void ClickBook_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            BookTimeLineVM temp = new BookTimeLineVM((VideoBook)e.Parameter);
            temp.ViewModelVideoViewer = ConsultationBookViewContextMenu.ActualVideoSourceVM;
            bool CanAdd = true;
           foreach(BookTimeLineVM BookTLVM in SelectedVideoBooks)
           {
               if (BookTLVM.SelectedBook == (VideoBook)e.Parameter)
               {
                   CanAdd = false;
               }
           }
            if(CanAdd)
            {
                SelectedVideoBooks.Add(temp);
            }

        }

      
        private AnnotationMakerVM _annotationMakerVM;
        public AnnotationMakerVM ViewModelAnnotationMaker
        {
            get
            {
                return _annotationMakerVM;
            }
        }
        void CreateNewTextualAnnotation_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            ViewModelAnnotationMaker.RefElement = SelectedElement;
        }
        public ConsultationViewVM()
        {
            InitializeCommands();
            _consultationBookViewContextMenu = new ConsultationBookViewVM();
            _annotationMakerVM = new AnnotationMakerVM();
            SelectedVideoBooks = new SLExtensions.Collections.ObjectModel.ObservableCollection<BookTimeLineVM>();
        }

        void SelectPolemicElement_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedElement= (PolemicElement)e.Parameter;
            try
            {
                ConsultationBookViewContextMenu.SelectedIndex = (SegmentIndex)SelectedElement;
            }
            catch
            {
            }
            


        }
    }
}
