﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
using System.Threading;
using Iri.Modernisation.Data.LDTClass;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// Classe VideoLivre
    /// </summary>
    public class VideoBook
    {
        /// <summary>
        /// Titre du VideoLivre
        /// </summary>
        public String Title { get; set; }

        /// <summary>
        /// Auteur du VideoLivre
        /// </summary>
        public User Author { get; set; }

        /// <summary>
        /// Chapitre du VideoLivre
        /// </summary>
        public VideoChapter[] Chapters { get; set; }

        /// <summary>
        /// Durée du VideoLivre
        /// </summary>
        public TimeSpan Duration { get; set; }

        /// <summary>
        /// Chemin de la vidéo fini
        /// </summary>
        public String MediaPath { get; set; }

        /// <summary>
        /// Chemin du projet .ldt
        /// </summary>
        public String LdtPath { get; set; }

        /// <summary>
        /// Chemin du .iri
        /// </summary>
        public String IriPath { get; set; }

        

        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public VideoBook()
        {
            Chapters = new VideoChapter[FactoryVideoLivre.VideoChapterDescriptions.Length];
            for (int nbChapitre = 0; nbChapitre < FactoryVideoLivre.VideoChapterDescriptions.Length; nbChapitre++)
            {
                Chapters[nbChapitre] = new VideoChapter(this,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Id,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Title,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Color);

            }
         
        }

        /// <summary>
        /// Méthode static pour le Loader de la list de videoBook
        /// </summary>
        /// <param name="XDoc">XDoc du fichier pointant tous les chemin .ldt des videoLivre disponible</param>
        /// <returns>List des VideoLivre (non chargé)</returns>
        public static List<VideoBook> GetListVideoBook(XDocument XDoc)
        {
            
            List<VideoBook> ListReturn = new List<VideoBook>();
            
            foreach (XElement XVideoBook in XDoc.Root.Elements())
            {

                VideoBook temp = new VideoBook();
                temp.LdtPath = XVideoBook.Attribute("metafile").Value; ;
                temp.Title = XVideoBook.Attribute("title").Value;
                ListReturn.Add(temp);


            }
            return ListReturn;
        }
           
        
        
    }

    public class VideoBookLoader
    {
        private Loader<IRIFile> _iriFile;
        private Loader<LDTFile> _ldtFile;
        private IRIFile _loadedIriFile;
        private LDTFile _loadedLdtFile;
        public VideoBookLoader()
        {
            _iriFile = new Loader<IRIFile>(IRIFile.FromXML);
            _ldtFile = new Loader<LDTFile>(LDTFile.FromXML);
            _ldtFile.LoaderFinished += new EventHandler<EventArgs>(_ldtFile_LoaderFinished);
            _iriFile.LoaderFinished += new EventHandler<EventArgs>(_iriFile_LoaderFinished);
        }

        void _iriFile_LoaderFinished(object sender, EventArgs e)
        {
            _loadedIriFile = ((LoaderEventArgs<IRIFile>)e).CreatedObject;
            LoaderFinished(this,new LoaderEventArgs<VideoBook>(LDTFileReader.ConvertToVideoBook(_loadedLdtFile,_loadedIriFile)));
        }

        void _ldtFile_LoaderFinished(object sender, EventArgs e)
        {
            _loadedLdtFile = ((LoaderEventArgs<LDTFile>)e).CreatedObject;
            _iriFile.Load(_loadedLdtFile.Medias[0].Src);
            
        }

        public event EventHandler<LoaderEventArgs<VideoBook>> LoaderFinished;

        
    }


    /// <summary>
    /// Comparateur pour Trier les livres
    /// </summary>
    public class VideoBookComparer : IComparer<VideoBook>
    {
        public int Compare(VideoBook x, VideoBook y)
        {
            return x.Title.CompareTo(y.Title);
        }
    }

}
