﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.Models
{
    public static class FactoryVideoLivre
    {
         public static WebClient xmlClient = new WebClient();
         private static XDocument _configDoc; 
         public static VideoChapterDescription[] VideoChapterDescriptions {get;private set;}
         public static PolemicTypeDescription[] AnnotationDescriptions { get; private set; }
         public static String VideoBookListPath;
         public static String ProductionVideoPath;
         public static int NumberOfChapters
         {
             get
             {
                 return VideoChapterDescriptions.Length;
             }
         }
         static FactoryVideoLivre()
	    {
 

	    }
        static public void Initialize()
        {
          //  LoadXMLFile();
        }
        public static void LoadXMLFile(String path)
        {

            
            
            xmlClient.DownloadStringCompleted += new DownloadStringCompletedEventHandler(XMLFileLoaded);
            Uri uri = new Uri(path, UriKind.RelativeOrAbsolute);
            xmlClient.DownloadStringAsync(uri);
          
            
        }

        static void XMLFileLoaded(object sender, DownloadStringCompletedEventArgs e)
        {

            if (e.Error == null)
            {
            
                _configDoc = XDocument.Parse(e.Result);
                List<VideoChapterDescription> temp = new List<VideoChapterDescription>();
                List<PolemicTypeDescription> temp_an = new List<PolemicTypeDescription>();
                int nb = 0;
                VideoBookListPath = _configDoc.Root.Attribute("VideoBookList").Value;
                ProductionVideoPath = _configDoc.Root.Attribute("ProductionVideo").Value;
                foreach (XElement XChapter in _configDoc.Root.Element("VideoBook").Elements())
                {
                    temp.Add(new VideoChapterDescription(nb, XChapter.Attribute("name").Value, XChapter.Attribute("color").Value));
                    nb++;
                }
                foreach (XElement XAnnotation in _configDoc.Root.Element("PolemicTypes").Elements())
                {
                    temp_an.Add(new PolemicTypeDescription(XAnnotation.Attribute("name").Value, XAnnotation.Attribute("color").Value));
                }
             
                VideoChapterDescriptions = temp.ToArray();
                AnnotationDescriptions = temp_an.ToArray();
                FactoryReady(null, new EventArgs());
            }
            else
            {
                MessageBox.Show(e.Error.Message);
            }
            

        }
        public static event EventHandler FactoryReady;
       static public void Load(string path)
       {
         
           _configDoc = XDocument.Load(path);
           List<VideoChapterDescription> temp_vl = new List<VideoChapterDescription>();

           List<PolemicTypeDescription> temp_an = new List<PolemicTypeDescription>();
           int nb = 0;
           foreach (XElement XChapter in _configDoc.Root.Element("VideoBook").Elements())
           {
               temp_vl .Add(new VideoChapterDescription(nb,XChapter.Attribute("name").Value, XChapter.Attribute("color").Value));
               nb++;
           }
           foreach (XElement XAnnotation in _configDoc.Root.Element("PolemicTypes").Elements())
           {
               temp_an.Add(new PolemicTypeDescription(XAnnotation.Attribute("name").Value, XAnnotation.Attribute("color").Value));
           }
           VideoChapterDescriptions = temp_vl .ToArray();
           AnnotationDescriptions = temp_an.ToArray();
       }

     


       
    }
}
