﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIDecoupage
    {
     

        public String Id { get; set; }
        public Color Color { get; set; }
        public String Author { get; set; }
        public DateTime Date { get; set; }
        public int Display { get; set; }
        public String Title { get; set; }
        public String Label { get; set; }
        public String Abstract { get; set; }
        public List<IRIElement> Elements { get; set; }

        public IRIDecoupage()
        {
            Id = String.Empty;
            Color = Color.FromArgb(0, 0, 0, 0);
            Author = String.Empty;
            Date = DateTime.Now;
            Display = 0;
            Title = String.Empty;
            Label = String.Empty;
            Abstract = String.Empty;
            Elements = new List<IRIElement>();
        }
        public IRIDecoupage(XElement elem)
        {
            Id = elem.Attribute("id").Value;
            Color = Color.FromArgb(0, 0, 0, 0);
            Author = elem.Attribute("author").Value;
            Date = DateTime.Parse(elem.Attribute("date").Value);
            Display = int.Parse(elem.Attribute("display").Value);
            Title = elem.Attribute("title").Value;
            Label = elem.Attribute("label").Value;
            Abstract = elem.Attribute("abstract").Value;
            foreach (XElement XIElement in elem.Element("elements").Elements())
            {
                Elements.Add(new IRIElement(XIElement));
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("decoupage",
                    new XAttribute("id", Id),
                    new XAttribute("color", Color),
                    new XAttribute("author", Author),
                    new XAttribute("date", Date.ToString("dd/MM/yyyy")),
                    new XAttribute("display", Display),
                    new XAttribute("title", Title),
                    new XAttribute("label", Label),
                    new XAttribute("abstract", Abstract));
                foreach (IRIElement element in Elements)
                {
                    temp.Add(element.XML);
                }
                return temp;
            }
        }

    }
}
