﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Controls.ViewModel;
namespace Iri.Modernisation.Controls.View
{
    public partial class CustomableIndexElement : UserControl
    {
        
        public double TrimRight
        {
            get { return (double)GetValue(TrimRightProperty); }
            set
            {
                if (((CustomableIndexElementVM)DataContext).TimerOut>TimeSpan.Zero)
                {
                    SetValue(TrimRightProperty, value);
                    ((CustomableIndexElementVM)DataContext).TimerOut = ((CustomableIndexElementVM)DataContext).TimerOut.Subtract(new TimeSpan(0, 0, 0, 0, (int)((value) / ProductionTimeLine.ScaleTime)));
                    this.Width = ((CustomableIndexElementVM)DataContext).Duration;
                   
                }
            }
        }

        // Using a DependencyProperty as the backing store for TrimRight.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty TrimRightProperty =
            DependencyProperty.Register("TrimRight", typeof(double), typeof(CustomableIndexElement), null);

        public CustomableIndexElement()
        {
            InitializeComponent();
        }
    }
}
