﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using Iri.Modernisation.Data.Models;
using System.Collections.ObjectModel;
using System.Collections.Generic;
using Iri.Modernisation.Data.LDTClass;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel de ProductionView
    /// </summary>
    public class ProductionViewVM : BaseMVVM.ViewModel.ViewModel
    {

        private VideoSequence _selectedVideoSequence;
        /// <summary>
        /// VideoSequence Sélectionnée dans la liste
        /// </summary>
        public VideoSequence SelectedVideoSequence
        {
            get
            {
                return _selectedVideoSequence;
            }
            set
            {
                _selectedVideoSequence = value;
                ViewModelProductionEditor = new ProductionEditorVM(value);
                OnPropertyChanged("SelectedVideoSequence");
               
            }
        }

        private ObservableCollection<VideoSequence> _recordedVideoSequences;
        /// <summary>
        /// Liste des VideoSéquences Enregistrées
        /// </summary>
        public ObservableCollection<VideoSequence> RecordedVideoSequences
        {
            get
            {
                return _recordedVideoSequences;
            }
            set
            {
                _recordedVideoSequences = value;
                OnPropertyChanged("RecordedVideoSequences");
            }
        }


        private HeaderProductionVM _headerProductionVM;
        /// <summary>
        /// ViewModel de HeaderProduction
        /// </summary>
        public HeaderProductionVM ViewModelHeaderProduction
        {
            get
            {
                return _headerProductionVM;
            }
            set
            {
                _headerProductionVM = value;
                OnPropertyChanged("ViewModelHeaderProduction");
            }
        }

        private ProductionTimeLineVM _productionTimeLineVM;
        /// <summary>
        /// ViewModel de ProductionTimeLine
        /// </summary>
        public ProductionTimeLineVM ViewModelProductionTimeLine
        {
            get
            {
                return _productionTimeLineVM;
            }
            set
            {
                _productionTimeLineVM = value;
                OnPropertyChanged("ViewModelProductionTimeLine");
            }
        }

        private ProductionEditorVM _productionEditorVM;
        /// <summary>
        /// ViewModel du ProductionEditor
        /// </summary>
        public ProductionEditorVM ViewModelProductionEditor
        {
            get
            {
                return _productionEditorVM;
            }
            set
            {
                _productionEditorVM = value;
                OnPropertyChanged("ViewModelProductionEditor");
            }
        }

        private VideoViewerVM _masterVideoViewerVM;
        /// <summary>
        /// ViewModel du Master
        /// </summary>
        public VideoViewerVM ViewModelMasterVideoViewer
        {
            get
            {
                return _masterVideoViewerVM;
            }
            set
            {
                _masterVideoViewerVM = value;
                OnPropertyChanged("ViewModelMasterVideoViewer");
            }
        }


       private void InitializeCommands()
       {
            Commands.ProductionView.ClickAddSelectedRecord.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickAddSelectedRecord_Executed);
         
            ViewModelMasterVideoViewer.Tick += new EventHandler<VideoViewerVMEventArgs>(ViewModelMasterVideoViewer_Tick);
            ViewModelHeaderProduction.Change += new EventHandler<HeaderProductionVMArgs>(ViewModelHeaderProduction_Change);
            Commands.HeaderProduction.PublishClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(PublishClick_Executed);    
           
       }
        public ProductionViewVM()
        {
            RecordedVideoSequences = new ObservableCollection<VideoSequence>();
            ViewModelHeaderProduction = new HeaderProductionVM();
            ViewModelProductionTimeLine = new ProductionTimeLineVM();
            ViewModelProductionEditor = new ProductionEditorVM();
            ViewModelMasterVideoViewer = new VideoViewerVM(true, false);
      
            ViewModelProductionTimeLine.ViewModelVideoViewer = ViewModelMasterVideoViewer;

            
      
           
            InitializeCommands();
            OnPropertyChanged(String.Empty);
           
        }
        void PublishClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IRIFile newFile = new IRIFile();
            IRIDecoupage decoupage = new IRIDecoupage()
            {
                Author = "this author",
                Id = "Index"

            };
            foreach (ObservableCollection<SegmentIndex> Ocsi in this.ViewModelProductionTimeLine.ListIndex)
            {
                foreach (SegmentIndex si in Ocsi)
                {
                    IRIElement temp = new IRIElement()
                    {
                        
                        Chapter = si.Chapter.IdChap,
                        Begin = si.TimerIn,
                        Dur = si.Duration,
                        Title = si.Description,
                        Abstract = si.Description,
                        Tags = si.Tags
                    };
                    decoupage.Elements.Add(temp);
                }

            }
            IRIMedia videoMedia = new IRIMedia() { Id = "video" };


            foreach (VideoSequence vs in this.ViewModelProductionTimeLine.TimeLine)
            {
                videoMedia.Videos.Add(new IRIVideo()
                {
                    Begin = vs.TimerIn,
                    Dur = vs.Duration,
                    Src = vs.Path,

                }
                );
            }
            IRIEnsemble ensemble = new IRIEnsemble()
            {
                Id = "VideoBookIndex"
            };
            ensemble.Decoupages.Add(decoupage);
            newFile.Body.Ensembles.Add(ensemble);
            newFile.Body.Medias.Add(videoMedia);

            MessageBox.Show(newFile.ToString());
        }
        void ViewModelHeaderProduction_Change(object sender, HeaderProductionVMArgs e)
        {
            if (e.ChapterHeader.Indexing == false && e.ChapterHeader.Editing == true)
            {
                ViewModelProductionTimeLine.IsIndexing = true;
            }
            else
            {
                ViewModelProductionTimeLine.IsIndexing = false;
            }       
            ViewModelProductionTimeLine.SelectedChapter = e.ChapterHeader.ChapterDescription.Id ;
        }

       

        private void ViewModelMasterVideoViewer_Tick(object sender, VideoViewerVMEventArgs e)
        {
            double newPos = ViewModelProductionTimeLine.ActualVideoSequence.TimerIn.TotalMilliseconds + e.Position.TotalMilliseconds;
            if (ViewModelProductionTimeLine.ActualVideoSequence.TimerOut.TotalMilliseconds <= newPos)
            {
                if (ViewModelProductionTimeLine.TimeLine.IndexOf(ViewModelProductionTimeLine.ActualVideoSequence) + 1 < ViewModelProductionTimeLine.TimeLine.Count)
                {
                    ViewModelProductionTimeLine.ActualVideoSequence = ViewModelProductionTimeLine.TimeLine[ViewModelProductionTimeLine.TimeLine.IndexOf(ViewModelProductionTimeLine.ActualVideoSequence) + 1];
                    ViewModelMasterVideoViewer.BeginIn = ViewModelProductionTimeLine.ActualVideoSequence.BeginTrim;
                    ViewModelMasterVideoViewer.Source = ViewModelProductionTimeLine.ActualVideoSequence.Path;
                    ViewModelMasterVideoViewer.GoTo(ViewModelProductionTimeLine.ActualVideoSequence.BeginTrim);
                }
                else
                {
                    ViewModelMasterVideoViewer.Pause();
                }
            }
            ViewModelProductionTimeLine.Position = newPos;
        }

        private void ClickAddSelectedRecord_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (ViewModelHeaderProduction.SelectedChapter != null && ViewModelHeaderProduction.SelectedChapter.IsActive)
            {
                if (!ViewModelProductionTimeLine.IsIndexing)
                {
                    if (SelectedVideoSequence != null)
                    {
                        ViewModelMasterVideoViewer.Source = SelectedVideoSequence.Path;

                        VideoSequence newVideo = new VideoSequence(SelectedVideoSequence);
                        ViewModelProductionTimeLine.ActualVideoSequence = newVideo;
                            ViewModelProductionTimeLine.SelectedVideoSequences.Add(newVideo);
                            ViewModelProductionTimeLine.Position = ViewModelProductionTimeLine.TimeLine[ViewModelProductionTimeLine.TimeLine.Count - 1].TimerIn.TotalMilliseconds;
                    }
                }
               
            }
         
           
        }
       
       
    }
}
