﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Editing
    /// </summary>
    public class LDTEditing
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Tags { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Title { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Abstract { get; set; }
        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTEdit> Edits { get; set; }
        public LDTEditing(XElement e) 
        {
            Edits = new List<LDTEdit>();
            Id = int.Parse(e.Attribute("id").Value);
            Tags = e.Attribute("tags").Value;
            Title = e.Element("title").Value;
            Abstract = e.Element("abstract").Value;
            foreach (XElement Elem in e.Elements("edit"))
            {
                Edits.Add(new LDTEdit(Elem));  
            }
        }

        public XElement XML
        {
            get
            {
                XElement temp = new XElement("editing",
                    new XAttribute("id",Id),
                    new XAttribute("tags",Tags),
                    new XElement("title",Title),
                    new XElement("abstract",Abstract)
                    );

              
                foreach (LDTEdit edit in Edits)
                {
                    temp.Add(edit.XML);
                }
                return temp;
            }
        }
    }
}
