﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Display
    /// </summary>
    public class LDTDisplay
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public int Id{get;set;}
        /// <summary>
        /// Attribut
        /// </summary>
        public String Title{get;set;}
        /// <summary>
        /// Attribut
        /// </summary>
        public String IdSel{get;set;}
        /// <summary>
        /// Attribut
        /// </summary>
        public int Tc{get;set;}
        /// <summary>
        /// Attribut
        /// </summary>
        public int Zoom{get;set;}
        /// <summary>
        /// Attribut
        /// </summary>
        public int Scroll{get;set;}
        /// <summary>
        /// Attribut
        /// </summary>
        public String InfoBAB{get;set;}
        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTDisplaysContent> Content{get;set;}
        public LDTDisplay(XElement e)
        {
            Content = new List<LDTDisplaysContent>();

            Id = int.Parse(e.Attribute("id").Value);
            Title = e.Attribute("title").Value;
            IdSel = e.Attribute("idsel").Value;
            Tc = int.Parse(e.Attribute("tc").Value);
            Zoom = int.Parse(e.Attribute("zoom").Value);
            Scroll = int.Parse(e.Attribute("scroll").Value);
            InfoBAB = e.Attribute("infoBAB").Value;

            foreach (XElement Elem in e.Element("content").Elements())
            {
                Content.Add(new LDTDisplaysContent(Elem));                
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("display",
                    new XAttribute("id",Id),
                    new XAttribute("title",Title),
                    new XAttribute("idsel",IdSel),
                    new XAttribute("tc",Tc),
                    new XAttribute("zoom",Zoom),
                    new XAttribute("scroll",Scroll),
                    new XAttribute("infoBAB",InfoBAB)
                    );
                foreach (LDTDisplaysContent LDTDC in Content)
                {
                    temp.Add(LDTDC.XML);
                }
                return temp;

            }
        }

    }
}
