﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.ViewModel;
namespace Iri.Modernisation.Controls.View
{
	public partial class VideoViewer : UserControl
	{

   

        public String MediaSource
        {
            get
            { 
                return (String)GetValue(SourceProperty); 
            }
            set 
            { 
                SetValue(SourceProperty, value);
                if(DataContext != null)
                ((VideoViewerVM)DataContext).Source = value;
            }
        }

        // Using a DependencyProperty as the backing store for Source.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty SourceProperty =
            DependencyProperty.Register("MediaSource", typeof(String), typeof(VideoViewer), new PropertyMetadata(""));


		public VideoViewer()
		{
			// Required to initialize variables
			InitializeComponent();
            Commands.VideoPositionTimer.Tick += new EventHandler(VideoPositionTimer_Tick);
            Commands.GoToTime.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(GoToTime_Executed);
            Commands.VideoViewer.Pause.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Pause_Executed);
            Commands.VideoViewer.Play.Executed +=new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Play_Executed);
		}

        void GoToTime_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            VideoScreen.Position = TimeSpan.FromMilliseconds((double)e.Parameter);
        }

        void VideoPositionTimer_Tick(object sender, EventArgs e)
        {
           Commands.VideoViewer.SendPosition.Execute(VideoScreen.Position);
        }
        public void ChangePosition(TimeSpan TS)
        {
            VideoScreen.Position = TS;
            
        }
        void Pause_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            VideoScreen.Pause();
            Commands.VideoPositionTimer.Stop();
            if (Commands.VideoPositionTimer.IsEnabled)
            {
                MessageBox.Show("Click Time IS NOT STOPPED");
            }
        }

        void Play_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (e.Parameter == DataContext || e.Parameter == null)
            {
                
                VideoScreen.Play();
                Commands.VideoPositionTimer.Start();
            }
        }

		private void VideoScreen_MediaFailed(object sender, System.Windows.ExceptionRoutedEventArgs e)
		{
			MessageBox.Show(e.ErrorException.ToString());
		}

		private void VideoScreen_CurrentStateChanged(object sender, System.Windows.RoutedEventArgs e)
		{
            
		}

		private void VideoScreen_MarkerReached(object sender, System.Windows.Media.TimelineMarkerRoutedEventArgs e)
		{
            MessageBox.Show("toto");
		}
	}
}