﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class HeaderProductionVM : BaseMVVM.ViewModel.ViewModel
    {
        private String _instruction;
        #region Avancement


        private bool _isChap01EditingComplete = false;
        public bool IsChap01EditingComplete
        {
            get
            {
                return _isChap01EditingComplete;
            }
            set
            {
                _isChap01EditingComplete = value;
                OnPropertyChanged("IsChap01EditingComplete");
                GeneralRefresh();
                
            }
        }
        
        private bool _isChap01IndexingComplete = false;
        public bool IsChap01IndexingComplete
        {
            get
            {
                return _isChap01IndexingComplete;
            }
            set
            {
                _isChap01IndexingComplete = value;
                OnPropertyChanged("IsChap01IndexingComplete");
                GeneralRefresh();
            }
        }

        private bool _isChap02EditingComplete = false;
        public bool IsChap02EditingComplete
        {
            get
            {
                return _isChap02EditingComplete;
            }
            set
            {
                _isChap02EditingComplete = value;
                OnPropertyChanged("IsChap02EditingComplete");
                GeneralRefresh();
            }
        }

        private bool _isChap02IndexingComplete = false;
        public bool IsChap02IndexingComplete
        {
            get
            {
                return _isChap02IndexingComplete;
            }
            set
            {
                _isChap02IndexingComplete = value;
                OnPropertyChanged("IsChap02IndexingComplete");
                GeneralRefresh();
            }
        }

        private bool _isChap03EditingComplete= false;
        public bool IsChap03EditingComplete
        {
            get
            {
                return _isChap03EditingComplete;
            }
            set
            {
                _isChap03EditingComplete = value;
                OnPropertyChanged("IsChap03EditingComplete");
                GeneralRefresh();
            }
        }

        private bool _isChap03IndexingComplete= false;
        public bool IsChap03IndexingComplete
        {
            get
            {
                return _isChap03IndexingComplete;
            }
            set
            {
                _isChap03IndexingComplete = value;
                OnPropertyChanged("IsChap03IndexingComplete");
                GeneralRefresh();
            }
        }

        private bool _isChap04EditingComplete= false;
        public bool IsChap04EditingComplete
        {
            get
            {
                return _isChap04EditingComplete;
            }
            set
            {
                _isChap04EditingComplete = value;
                OnPropertyChanged("IsChap04EditingComplete");
                GeneralRefresh();
            }
        }

        private bool _isChap04IndexingComplete= false;
        public bool IsChap04IndexingComplete
        {
            get
            {
                return _isChap04IndexingComplete;
            }
            set
            {
                _isChap04IndexingComplete = value;
                OnPropertyChanged("IsChap04IndexingComplete");
                GeneralRefresh();
            }
        }
        #endregion

        #region Etat des Boutton
        private void GeneralRefresh()
        {
            OnPropertyChanged("IsChap01EditingEnable");
            OnPropertyChanged("IsChap01IndexingEnable");
            OnPropertyChanged("IsChap02EditingEnable");
            OnPropertyChanged("IsChap02IndexingEnable");
            OnPropertyChanged("IsChap03EditingEnable");
            OnPropertyChanged("IsChap03IndexingEnable");
            OnPropertyChanged("IsChap04EditingEnable");
            OnPropertyChanged("IsChap04IndexingEnable");
            OnPropertyChanged("IsVideoBookComplete");
        }
        public bool IsChap01EditingEnable
        {
            get
            {
                return !IsChap01EditingComplete;
            }
        }
        public bool IsChap01IndexingEnable
        {
            get
            {
                return IsChap01EditingComplete^IsChap01IndexingComplete;
            }
        }
        public bool IsChap02EditingEnable
        {
            get
            {      
                 return IsChap01EditingComplete ^ IsChap02EditingComplete;
            }
        }
        public bool IsChap02IndexingEnable
        {
            get
            {
                return IsChap02EditingComplete ^ IsChap02IndexingComplete;
            }
        }
        public bool IsChap03EditingEnable
        {
            get
            {
                return IsChap02EditingComplete ^ IsChap03EditingComplete;
            }
        }
        public bool IsChap03IndexingEnable
        {
            get
            {
                return IsChap03EditingComplete ^ IsChap03IndexingComplete;
            }
        }
        public bool IsChap04EditingEnable
        {
            get
            {
                return IsChap03EditingComplete ^ IsChap04EditingComplete;
            }
        }
        public bool IsChap04IndexingEnable
        {
            get
            {
                return IsChap04EditingComplete^IsChap04IndexingComplete;
            }
        }
        #endregion
        public bool IsVideoBookComplete
        {
            get
            {
                return _isChap01EditingComplete && _isChap01IndexingComplete
                && _isChap02EditingComplete && _isChap02IndexingComplete
                && _isChap03EditingComplete && _isChap03IndexingComplete
                && _isChap04EditingComplete && _isChap04IndexingComplete;
            }
        }
         /******************************************************************/
        /**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/
       /******************************************************************/
        private bool _istest;
        public bool IsTest
        {
            get
            {
                return _istest;
            }
            set
            {
                _istest = value;
                OnPropertyChanged("IsTest");
            }
        }

        public String Instruction
        {
            get
            {
                return _instruction;
            }
            set
            {
                _instruction = value;
                OnPropertyChanged("Instruction");
            }
        }
        public HeaderProductionVM()
        {
            IsTest = false;
            Commands.Action.CanExecute += (sender, e) => e.CanExecute = this.IsTest;
            _instruction = Iri.Modernisation.Controls.Resources.HeaderProduction.InstructionTextRessource.Introduction;

            InitializeCommands();
              }
        private void InitializeCommands()
        {
                Commands.HeaderProduction.Chap01EditingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap01EditingOkClick_Executed);
                Commands.HeaderProduction.Chap02EditingOkClick.Executed+=new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap02EditingOkClick_Executed);
                Commands.HeaderProduction.Chap03EditingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap03EditingOkClick_Executed);
                Commands.HeaderProduction.Chap04EditingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap04EditingOkClick_Executed);

                Commands.HeaderProduction.Chap01IndexingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap01IndexingOkClick_Executed);
                Commands.HeaderProduction.Chap02IndexingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap02IndexingOkClick_Executed);
                Commands.HeaderProduction.Chap03IndexingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap03IndexingOkClick_Executed);
                Commands.HeaderProduction.Chap04IndexingOkClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Chap04IndexingOkClick_Executed);
        }

        void Chap04IndexingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap04IndexingComplete = true;
        }

        void Chap03IndexingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap03IndexingComplete = true;
        }

        void Chap02IndexingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap02IndexingComplete = true;
        }

        void Chap01IndexingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap01IndexingComplete = true;
        }

        void Chap04EditingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap04EditingComplete = true;
        }

        void Chap03EditingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap03EditingComplete = true;
        }

        void  Chap02EditingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            IsChap02EditingComplete = true;
        }
        void Chap01EditingOkClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            this.IsChap01EditingComplete = true;
        }
    }
}
