﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Collections;
using Iri.Modernisation.Data.Models;
using System.Linq;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ConsultationBookViewVM : BaseMVVM.ViewModel.ViewModel
    {

        private VideoBook _selectedBook;
        public VideoBook SelectedBook
        {
            get
            {
                return _selectedBook;
            }
            set
            {
                _selectedBook = value;
                OnPropertyChanged(null);
            }
        }

        private int _selectedIndexNumber = 0;

        private SegmentIndex _selectedIndex;
        public SegmentIndex SelectedIndex
        {
            get
            {
                
                return _selectedIndex;
            }
            set
            {
                _selectedIndex = value;
                _selectedIndexTitle = ((SegmentIndex)value).Title;
                _selectedIndexDescription = ((SegmentIndex)value).Description;
                _selectedIndexTags = ((SegmentIndex)value).Tags;
                _selectedBook = _selectedIndex.Chapter.Book;
                _title = _selectedIndex.Chapter.Book.Title;
                _author = _selectedIndex.Chapter.Book.Author;
                _chapters = _selectedIndex.Chapter.Book.Chapters;
                _selectedIndexAnnotation.Clear();
                List<AnnotationViewerVM> _temp = new List<AnnotationViewerVM>();
                foreach (Annotation An in ((SegmentIndex)value).Chapter.Annotations)
                {
                    if (An.TimerIn <= ((SegmentIndex)value).TimerOut && An.TimerOut >= ((SegmentIndex)value).TimerIn)
                    {
                          _temp.Add(new AnnotationViewerVM (An));
                    }
                }
                SelectedIndexAnnotation = _temp;

                OnPropertyChanged(null);
            
         
            }
        }

        private String _selectedIndexTitle;
        public String SelectedIndexTitle
        {
            get
            {
                return _selectedIndexTitle;
            }
            set
            {
                _selectedIndexTitle = value;
                OnPropertyChanged("SelectedIndexTitle");
            }
        }

        private String _selectedIndexDescription;
        public String SelectedIndexDescription
        {
            get
            {
                return _selectedIndexDescription;
            }
            set
            {
                _selectedIndexDescription = value;
                OnPropertyChanged("SelectedIndexDescription");
            }
        }

        private List<String> _selectedIndexTags = new List<string>();
        public String SelectedIndexTags
        {
            get
            {
                try
                {
                    return String.Join(",", _selectedIndexTags.ToArray());
                }
                catch
                {
                    return String.Empty;
                }
            }
            set
            {
                String val = (String)value;
                _selectedIndexTags = val.Split(',').ToList();
                OnPropertyChanged("SelectedIndexTags");
            }
        }

        private List<AnnotationViewerVM> _selectedIndexAnnotation = new List<AnnotationViewerVM>();
        public List<AnnotationViewerVM> SelectedIndexAnnotation
        {
            get
            {
               return _selectedIndexAnnotation;
            }
            set
            {
                _selectedIndexAnnotation = value;
                OnPropertyChanged("SelectedIndexAnnotation");
            }
        }
        

        private String _title;
        public String Title
        {
            get
            {
                return _title;
            }
            private set
            {
                _title = value;
                _selectedBook.Title = value;
                OnPropertyChanged("Title");
            }
        }

        private User _author;
        public User Author
        {
            get
            {
                return _author;
            }
            private set
            {
                _author = value;
                _selectedBook.Author = value;
                OnPropertyChanged("Author");
            }

        }

        private VideoChapter[] _chapters;
        public VideoChapter[] Chapters
        {
            get
            {
                return _chapters;
            }
            private set
            {
                _chapters = value;
                _selectedBook.Chapters = value;
                OnPropertyChanged("Chapters");
            }
        }

        private List<SegmentIndex>[] _segmentIndex = new List<SegmentIndex>[4];
        public List<SegmentIndex>[] SegmentIndex
        {
            get
            {
                return _segmentIndex;
            }
            set
            {
                _segmentIndex = value;
                OnPropertyChanged("SegmentIndex");
            }
        }

        private List<Annotation>[] _annotations = new List<Annotation>[4];
        public List<Annotation>[] Annotations
        {
            get
            {
                return _annotations;
            }
            set
            {
                _annotations = value;
                OnPropertyChanged("Annotations");
            }
        }

        private BookTimeLineVM _selectedBookVM;
        public BookTimeLineVM SelectedBookVM
        {
            get
            {
                return _selectedBookVM;
            }
            set
            {
                _selectedBookVM = value;
             
                _selectedBook = value.SelectedBook;
                _title = value.SelectedBook.Title;
                _author = value.SelectedBook.Author;
                _chapters = value.SelectedBook.Chapters;
              
                    ActualVideoSourceVM.Position = TimeSpan.FromMilliseconds(value.Position);
                    ActualVideoSourceVM.Source = value.SelectedBook.MediaPath;
               
                
                SelectedIndex = value.SelectedBook.Chapters[0].Index[0];
             
                OnPropertyChanged(null);
                Commands.GoToTime.Execute(value.Position);
            }
        }
        private VideoViewerVM _actualVideoSourceVM;
        public VideoViewerVM ActualVideoSourceVM
        {
            get
            {
                return _actualVideoSourceVM;
            }
            set
            {
                _actualVideoSourceVM = value;
                OnPropertyChanged("ActualVideoSourceVM");
            }
        }
        public ConsultationBookViewVM()
        {
           /* _selectedBookVM = param;
            _selectedBook = param.SelectedBook;
            _title = param.SelectedBook.Title;
            _author = param.SelectedBook.Author;
            _chapters = param.SelectedBook.Chapters;
            //
            if (param.SelectedBook.Chapters[0].VideoSequences.Count != 0)
            { _actualVideoSource = param.SelectedBook.Chapters[0].VideoSequences[0].Path; }
            SelectedIndex = param.SelectedBook.Chapters[0].Index[0];*/
            ActualVideoSourceVM = new VideoViewerVM();
            InitializeCommands();


        }
        public ConsultationBookViewVM(BookTimeLineVM param)
        {
            _selectedBookVM = param;
            _selectedBook = param.SelectedBook;
            _title = param.SelectedBook.Title;
            _author = param.SelectedBook.Author;
            _chapters = param.SelectedBook.Chapters;
            //
            if (param.SelectedBook.Chapters[0].VideoSequences.Count != 0)
            {
                ActualVideoSourceVM = new VideoViewerVM() { Source = param.SelectedBook.MediaPath }; 
            }
            SelectedIndex = param.SelectedBook.Chapters[0].Index[0];
            
            InitializeCommands();


        }
        private void InitializeCommands()
        {
          
            Commands.VideoViewer.SendPosition.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(SendPosition_Executed);
        }

      

        void SendPosition_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            TimeSpan Pos = ((TimeSpan)e.Parameter);
            SelectedBookVM.Position = Pos.TotalMilliseconds;
            if (SelectedIndex.TimerOut < Pos || SelectedIndex.TimerIn > Pos)
            {
               foreach(SegmentIndex Index in SelectedIndex.Chapter.Index)
               {
                   if(Index.TimerIn <= Pos && Index.TimerOut>= Pos)
                   {
                       SelectedIndex = Index;
                   }
                  
               }
            }
        }

        
       
    }
}
