﻿using SLExtensions.Input;

namespace Iri.Modernisation.BaseMVVM.Commands
{
       /// <summary>
    /// Commandes
    /// </summary>
    public static class Commands
    {    
        /// <summary>
        /// Horloge Interne, Principalement pour syncroniser la position d'une video avec sa barre de défilement
        /// </summary>
       public static System.Windows.Threading.DispatcherTimer VideoPositionTimer = new System.Windows.Threading.DispatcherTimer();
       
        /// <summary>
        /// Commandes relatives au ConsultMenu
        /// </summary>
        public static class ConsultMenu
        {
            static ConsultMenu()
            {
              GetBook = new Command("GetBook");
              ClickBook = new Command("ClickBook");
            }
            public static Command GetBook
            {
                get;
                private set;
            }
            public static Command ClickBook
            {
                get;
                private set;
            }
            public static void Initialize()
            {
               
            }
       
        }
       
        /// <summary>
        /// Commandes relatives au PersonnalChutier
        /// </summary>
        public static class PersonnalChutier 
        {
            static PersonnalChutier()
            {
                //PersonnalChutier
                Search = new Command("Search");
                ClickAnnotation = new Command("ClickAnnotation");
            }
            public static Command Search
            {
                get;
                private set;
            }
            public static Command ClickAnnotation
            {
                get;
                private set;
            }
            public static void Initialize()
            {

            }
        }

        /// <summary>
        /// Commandes relatives au ReferencesChutier
        /// </summary>
        public static class ReferencesChutier
        {
            static ReferencesChutier()
            {
                //PersonnalChutier
                Search = new Command("iSearch");
                ClickAnnotation = new Command("iClickAnnotation");
                RefChutierAdd = new Command("RefChutierAdd");
            }
            public static Command RefChutierAdd
            {
                get;
                private set;
            }
            public static Command Search
            {
                get;
                private set;
            }
            public static Command ClickAnnotation
            {
                get;
                private set;
            }
            public static void Initialize()
            {

            }
        }
        
        /// <summary>
        /// Commandes relatives au AnnotationMaker
        /// </summary>
        public static class AnnotationMaker
        {
            static AnnotationMaker()
            {
                OkClick = new Command("OkClick");
                Play = new Command("Play");
                Pause = new Command("Pause");
                LeftTrim = new Command("LeftTrim");
                RightTrim = new Command("RightTrim");
            }
            public static Command OkClick
            {
                get;
                private set;
            }
            public static Command Play
            {
                get;
                private set;
            }
            public static Command Pause
            {
                get;
                private set;
            }
            public static Command LeftTrim
            {
                get;
                private set;
            }
            public static Command RightTrim
            {
                get;
                private set;
            }
            public static void Initialize()
            { 
            }


        }

        /// <summary>
        /// Commandes relatives au ClickMenu
        /// </summary>
        public static class ClickMenu
        {
            static ClickMenu()
            {
                ActionReleased = new Command("ActionReleased");
                CreateNewTextualAnnotation = new Command("CreateNewTextualAnnotation");
                AddToRefChutier = new Command("AddToChutier");
            }
            static public Command AddToRefChutier
            {
                get;
                private set;
            }
            static public Command CreateNewTextualAnnotation
            {
                get;
                private set;
            }

            static public Command ActionReleased
            {
                get;
                private set;
            }
        }

        /// <summary>
        /// Commandes relatives au HeaderControl
        /// </summary>
        public static class HeaderControl
        {
            static HeaderControl()
            {
                ButtonClick = new Command("ButtonClick");
            }

            static public Command ButtonClick
            {
                get;
                private set;
            }
            public static void Initialize()
            {
             
            }

        }

        /// <summary>
        /// Commandes relatives au PolemicElement
        /// </summary>
        public static class PolemicElement
        {
            static PolemicElement()
            {
                ElementSelected = new Command("ElementSelected");
                SelectPolemicElement = new Command("SelectPolemicElement");
            }
            public static Command ElementSelected
            {
                get;
                private set;
            }
            public static Command SelectPolemicElement
            {
                get;
                private set;
            }

            public static void Initialize()
              {
                 }

        }

        /// <summary>
        /// Commandes relatives au ConsultationBookView
        /// </summary>
        public static class ConsultationBookView
        {
            static ConsultationBookView()
            {

            }

            public static Command Action
            {
                get;
                private set;
            }

        }
        
        /// <summary>
        /// Commandes relatives au ContextualBinderLayer
        /// </summary>
        public static class ContextualBinderLayer
        {
            static ContextualBinderLayer()
            {
                BeginBind = new Command("BeginBind");
                EndBind = new Command("EndBind");
                ActiveBind = new Command("InBind");
                DesactiveBind = new Command("ActiveBind");
                SelectBind = new Command("SelectBind");
                UnSelectBind = new Command("UnSelectBind");
            }
            public static Command SelectBind
            {
                get;
                private set;
            }
            public static Command UnSelectBind
            {
                get;
                private set;
            }
            public static Command ActiveBind
            {
                get;
                private set;
            }
            public static Command DesactiveBind
            {
                get;
                private set;
            }
            public static Command BeginBind
            {
                get;
                private set;
            }

            public static Command EndBind
            {
                get;
                private set;
            }
            public static void Initialize()
            {
            }
        }

        /// <summary>
        /// Commandes relatives au HeaderProduction
        /// </summary>
        public static class HeaderProduction
        {
            static HeaderProduction()
            {
                Chap01EditingOkClick = new Command("Chap01EditingOkClick");
                Chap01IndexingOkClick = new Command("Chap01IndexingOkClick");

                Chap02EditingOkClick = new Command("Chap02EditingOkClick");
                Chap02IndexingOkClick = new Command("Chap02IndexingOkClick");

                Chap03EditingOkClick = new Command("Chap03EditingOkClick");
                Chap03IndexingOkClick = new Command("Chap03IndexingOkClick");

                Chap04EditingOkClick = new Command("Chap04EditingOkClick");
                Chap04IndexingOkClick = new Command("Chap04IndexingOkClick");

                PublishClick = new Command("PublishClick");
                SaveClick = new Command("SaveClick");

            }
            public static Command Chap01EditingOkClick
            {
                get;
                private set;
            }
            public static Command Chap01IndexingOkClick
            {
                get;
                private set;
            }
            public static Command Chap02EditingOkClick
            {
                get;
                private set;
            }
            public static Command Chap02IndexingOkClick
            {
                get;
                private set;
            }
            public static Command Chap03EditingOkClick
            {
                get;
                private set;
            }
            public static Command Chap03IndexingOkClick
            {
                get;
                private set;
            }
            public static Command Chap04EditingOkClick
            {
                get;
                private set;
            }
            public static Command Chap04IndexingOkClick
            {
                get;
                private set;
            }
            public static Command PublishClick
            {
                get;
                private set;
            }
            public static Command SaveClick
            {
                get;
                private set;
            }
            static public void Initialize()
            {}
        }

        /// <summary>
        /// Commandes relatives au ProductionTimeLine
        /// </summary>
        public static class ProductionTimeLine
        {
            static  ProductionTimeLine()
            {
            }

            static public void Initialize()
            { }
        }

        /// <summary>
        /// Commandes relatives au VideoViewer
        /// </summary>
        public static class VideoViewer
        {
            static VideoViewer()
            {
                Play = new Command("PlayVideo");
                Pause = new Command("PauseVideo");
                Next = new Command("NextVideo");
                Previous = new Command("PreviousVideo");
                Record = new Command("RecordVideo");
                Close = new Command("CloseVideo");
                SendPosition = new Command("SendPosition");
            }
            public static Command SendPosition
            {
                get;
                private set;
            }
            public static Command Play
            {
                get;
                private set;
            }
            public static Command Pause
            {
                get;
                private set;
            }
            public static Command Next
            {
                get;
                private set;
            }
            public static Command Previous
            {
                get;
                private set;
            }
            public static Command Record
            {
                get;
                private set;
            }
            public static Command Close
            {
                get;
                private set;
            }

            static public void Initialize()
            {

            }
        }

        /// <summary>
        /// Constructeur
        /// </summary>
        static Commands()
        {
            Action = new Command("Action");
            TimeChange = new Command("TimeChange");
            FlipView = new Command("FlipView");
            GoToTime = new Command("GoToTime");
            VideoPositionTimer.Interval = new System.TimeSpan(0, 0,0,0,1000); 
           // VideoPositionTimer.Tick += new EventHandler(Each_Tick);
           
           
        }
        public static Command Action
        {
            get;
            private set;
        }

        public static Command FlipView
        {
            get;
            private set;
        }
    

        public static Command TimeChange
        {
            get;
            private set;
        }

        public static Command GoToTime
        {
            get;
            private set;
        }

        
        /// <summary>
        /// Ensure static fields are initialized
        /// </summary>
        public static void Initialize()
        {
            ConsultMenu.Initialize();
            ReferencesChutier.Initialize();
            PersonnalChutier.Initialize();
            AnnotationMaker.Initialize();
            HeaderControl.Initialize();
            PolemicElement.Initialize();
            ContextualBinderLayer.Initialize();
            HeaderProduction.Initialize();
            ProductionTimeLine.Initialize();
            VideoViewer.Initialize();
        }
    }
}
