﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Data;
using SLExtensions.Input;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
using System.Collections.Generic;
using System.Linq;
using Iri.Modernisation.Controls.View;
namespace Iri.Modernisation.Controls.ViewModel
{

    /// <summary>
    /// ViewModel du module d'annotation
    /// </summary>
    public class AnnotationMakerVM : BaseMVVM.ViewModel.ViewModel
    {
       
        private PolemicElement _refElement;
        /// <summary>
        /// Element référent
        /// </summary>
        public PolemicElement RefElement
        {
            get
            {
                return _refElement;
            }
            set
            {
                _refElement = value;

                _newAnnotation = new Annotation(((PolemicElement)value).Chapter);
                Begin = ((PolemicElement)value).TimerIn.TotalMilliseconds;
                End = ((PolemicElement)value).TimerOut.TotalMilliseconds;
                BasicRelation = new PolemicLink() { FromElement = ((PolemicElement)value), ToElement = _newAnnotation, Type = PolemicElementType.Basic };
                PolemicRelation = new PolemicLink();
                PolemicRelation.FromElement = _newAnnotation;
               
                OnPropertyChanged(String.Empty);
                //OnPropertyChanged("RefElement");
                //OnPropertyChanged("IsControlEnable");
                
            }
        }

        /// <summary>
        /// Savoir si le module de liens est activé
        /// </summary>
        public bool IsBinderActive { get; set; }
        /// <summary>
        /// Liste des Tags Référants
        /// </summary>
        public List<String> RefTags
        {
            get
            {
                if (_refElement != null)
                {
                    return _refElement.Tags;
                }
                else
                {
                    return new List<String>();
                }
            }
        }

        /// <summary>
        /// Annotation créé
        /// </summary>
        private Annotation _newAnnotation;

        
        private TimeSpan _begin;
        /// <summary>
        /// Temps de début de l'annotation
        /// </summary>
        public double Begin 
        {
            get
            {
                return _begin.TotalMilliseconds;
            }
            set
            {
                _begin = TimeSpan.FromMilliseconds(value);
                _newAnnotation.TimerIn = TimeSpan.FromMilliseconds(value);
                OnPropertyChanged("Begin");
            }
        }

        
        private TimeSpan _end;
        /// <summary>
        /// Temps de fin de l'annotation
        /// </summary>
        public double End
        {
            get
            {
                return _end.TotalMilliseconds;
            }
            set
            {
                _end = TimeSpan.FromMilliseconds(value);
                _newAnnotation.TimerOut = TimeSpan.FromMilliseconds(value);
                OnPropertyChanged("End");
            }
        }

   
        private PolemicElementType _type;
        /// <summary>
        /// Type de l'annotation
        /// </summary>
        public PolemicElementType Type 
        {
            get
            {
                return _type;
            }
            set
            {
                _type = value;
                _newAnnotation.Type = value;
                OnPropertyChanged("Type");
            }
        }

        
        private Rectangle _selectedType;
        /// <summary>
        /// Convertion Rectange
        /// </summary>
        public Rectangle SelectedType
        {
            get
            {
                return _selectedType;
            }
            set
            {
                _selectedType = value;
               
                Type = (PolemicElementType)((Rectangle)_selectedType).Resources["PolemicType"];
            }
        }

        private String _title;
        /// <summary>
        /// Titre de l'annotation
        /// </summary>
        public String Title
        {
            get
            { return _title; }
            set
            {
                _title = value;
                _newAnnotation.Title = value;
                OnPropertyChanged("Title");
            }
        }

        private String _description;

        /// <summary>
        /// Description de l'annotation
        /// </summary>
        public String Description
        {
            get
            {
                return _description;
            }
            set
            {
                _description = value;
                _newAnnotation.Description = value;
                OnPropertyChanged("Description");
            }

        }

        /// <summary>
        /// Tags de l'annotation
        /// </summary>
        public List<String> _tags =new List<String>();
        /// <summary>
        /// Tags de l'annotation
        /// </summary>
        public String Tags
        {
            get
            {
                try
                {
                    return String.Join(",", _tags.ToArray());
                }
                catch 
                {
                    return String.Empty;
                }
            }
            set
            {
                String val = (String)value;
                _tags = val.Split(',').ToList();
                _newAnnotation.Tags = val.Split(',').ToList();
                OnPropertyChanged("Tags");
               
                
            }
        }

     
        private PolemicLink _basicRelation;
        /// <summary>
        /// Relation basique
        /// </summary>
        public PolemicLink BasicRelation
        {
            get
            {
                return _basicRelation;
            }
            set
            {
                _basicRelation = value;
                OnPropertyChanged("BasicRelation");
            }


        }

      
        private PolemicLink _polemicRelation;
        /// <summary>
        /// Relation polémique
        /// </summary>
        public PolemicLink PolemicRelation
        {
            get
            {

                return _polemicRelation;
            }
            set
            {
                _polemicRelation = value;
                OnPropertyChanged("PolemicRelation");
            }


        }

        /// <summary>
        /// Détermine si le control est activé ou non
        /// </summary>
        public bool IsControlEnable
        {
            get
            {
                return _refElement != null;
            }
        }

        /// <summary>
        /// Permet d'initialiser les commands;
        /// </summary>
        private void InitializeCommands()
        {
            Commands.ContextualBinderLayer.BeginBind.Executed += new EventHandler<ExecutedEventArgs>(BeginBind_Executed);
            Commands.ContextualBinderLayer.SelectBind.Executed += new EventHandler<ExecutedEventArgs>(SelectBind_Executed);
            Commands.ContextualBinderLayer.ActiveBind.Executed += new EventHandler<ExecutedEventArgs>(ActiveBind_Executed);
            Commands.ContextualBinderLayer.DesactiveBind.Executed += new EventHandler<ExecutedEventArgs>(DesactiveBind_Executed);
            Commands.AnnotationMaker.OkClick.Executed += new EventHandler<ExecutedEventArgs>(OkClickAnnotationMaker_Executed);
        }

        private void DesactiveBind_Executed(object sender, ExecutedEventArgs e)
        {
            IsBinderActive = false;
        }

        private void ActiveBind_Executed(object sender, ExecutedEventArgs e)
        {
            IsBinderActive = true;
        }

      

        private void SelectBind_Executed(object sender, ExecutedEventArgs e)
        {
            if (IsControlEnable && IsBinderActive )
            {
                PolemicRelation.ToElement = (PolemicElement)e.Source;
                OnPropertyChanged("PolemicRelation");
            }
                
        }

        private void BeginBind_Executed(object sender, ExecutedEventArgs e)
        {
            if (IsControlEnable)
            {
                PolemicRelation.Type = ((ContextualLinkBinder)e.Parameter).PolemicType;
                PolemicRelation.ToElement = null;
                OnPropertyChanged("PolemicRelation");
                
            }

        }

      

        private void OkClickAnnotationMaker_Executed(object sender, ExecutedEventArgs e)
        {
            String message = "Ok clicked "+Type+" \n";
            message += _begin + "-->" + _end;
            message += "\n" + Title;
            message += "\n" + Description;
            
                foreach (string tag in _tags)
                {
                    message += "\n|-" + tag;
                }

                message += "PolemicLink "+PolemicRelation.Type;
            MessageBox.Show(message);
        }

        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public AnnotationMakerVM()
        {

            InitializeCommands();

        }

        /// <summary>
        /// Constructeur par référence
        /// </summary>
        /// <param name="refAParam">Element référant</param>
        public AnnotationMakerVM(PolemicElement refAParam)
        {


            RefElement = refAParam;



            _newAnnotation = new Annotation(RefElement.Chapter);
            _begin = RefElement.TimerIn;
            _end = RefElement.TimerOut;
            _basicRelation = new PolemicLink() { FromElement = RefElement, ToElement = _newAnnotation, Type = PolemicElementType.Basic };
            _polemicRelation = new PolemicLink();
            PolemicRelation.FromElement = _newAnnotation;
            InitializeCommands();
        }


    }
   
}
