﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel de Main
    /// </summary>
    public class MainVM : BaseMVVM.ViewModel.ViewModel
    {
        private ConsultationViewVM _consultationViewVM;
        /// <summary>
        /// ViewModel de ConsultationView
        /// </summary>
        public ConsultationViewVM ViewModelConsultationView
        {
            get
            {
                return _consultationViewVM;
            }
            set
            {
                _consultationViewVM = value;
                OnPropertyChanged("ViewModelConsultationView");
            }
        }

        private NavigationBarVM _navigationBarVM;
        /// <summary>
        /// ViewModel de NavigationBar
        /// </summary>
        public NavigationBarVM ViewModelNavigationBar
        {
            get
            {
                return _navigationBarVM;
            }
            set
            {
                _navigationBarVM = value;
                OnPropertyChanged("ViewModelNavigationBar");
            }
        }

        private HeaderControlVM _headerControlVM;
        /// <summary>
        /// ViewsModel de HeaderControl
        /// </summary>
        public HeaderControlVM ViewModelHeaderControl
        {
            get
            {
                return _headerControlVM;
            }
            set
            {
                _headerControlVM = value;
                OnPropertyChanged("ViewModelHeaderControl");
            }
        }

        private ProductionViewVM _productionViewVM;
        /// <summary>
        /// ViewModel de ProductionView
        /// </summary>
        public ProductionViewVM ViewModelProductionView
        {
            get
            {
                return _productionViewVM;
            }
            set
            {
                _productionViewVM = value;
                OnPropertyChanged("ViewModelProductionView");
            }
        }

        public MainVM(List<VideoBook> videoBooks)
        {

            InitializeCommands();
            List<VideoBook> SelectedVideoBooks = videoBooks;


            // Initialisation des Components //
            ViewModelProductionView = new ProductionViewVM();
            ViewModelConsultationView = new ConsultationViewVM();
            ViewModelNavigationBar = new NavigationBarVM() { ConsultMenuViewModel = new ConsultMenuVM(SelectedVideoBooks) };
            ViewModelHeaderControl = new HeaderControlVM();
          
        }

        private void InitializeCommands()
        {
            Commands.Initialize();
        }
       
    }
}
