﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// 
    /// </summary>
    public abstract class SegmentElement
    {
        /// <summary>
        /// Temps d'entrée 
        /// </summary>
            public TimeSpan TimerIn{get;set; }
        /// <summary>
        /// Temps de sortie
        /// </summary>
            public TimeSpan TimerOut{ get;set;}
        /// <summary>
        /// Durée du segment
        /// </summary>
            public TimeSpan Duration
            {
                get { return TimerOut - TimerIn; }
                set { TimerOut = TimerIn + value; }
            }
            /// <summary>
            /// Constructeur par défaut
            /// </summary>
            public SegmentElement()
            {
            }
        /// <summary>
        /// Constructeur par copie
        /// </summary>
        /// <param name="copy">Element à copier</param>
            public SegmentElement(SegmentElement copy)
            {
                this.TimerIn = copy.TimerIn;
                this.TimerOut = copy.TimerOut;
            }

    }
}
