﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Fichier .ldt
    /// </summary>
    public class LDTFile
    {
        
        public String Path { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public LDTProject Project { get; set; }

        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTMedia> Medias { get; set; }

        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTAnnotationsContent> Annotations { get; set; }

        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTDisplay> Displays { get; set; }


        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTEditing> Edits { get; set; }

        public LDTFile()
        {
            Project = new LDTProject();
            Medias = new List<LDTMedia>();
            Annotations = new List<LDTAnnotationsContent>();
            Displays = new List<LDTDisplay>();
            Edits = new List<LDTEditing>();
        }
        public void Load(String _path)
        {
            Path = _path;
            Load();
        }
        public void Load()
        {
            if(Path == String.Empty)
            {
                throw new Exception("Load Path Needed");
            }
            XDocument xdoc = XDocument.Load(Path);

            Project = new LDTProject(xdoc.Root.Element("project"));
            foreach (XElement Elem in xdoc.Root.Element("medias").Elements())
            {
                Medias.Add(new LDTMedia(Elem));
            }

            foreach (XElement Elem in xdoc.Root.Element("annotations").Elements())
            {
                Annotations.Add(new LDTAnnotationsContent(Elem));
            }

            foreach (XElement Elem in xdoc.Root.Element("displays").Elements())
            {
                Displays.Add(new LDTDisplay(Elem));
            }

            foreach (XElement Elem in xdoc.Root.Element("edits").Elements())
            {
                Edits.Add(new LDTEditing(Elem));
            }
        }
        public XDocument XMLFile
        {
            get
            {
                return new XDocument(XML);
               
            }

        }
        public XElement XML
        {
            get
            {
                
                XElement temp = new XElement("iri",
                    new XAttribute(XNamespace.Xmlns+"dc",@"http://dublincore.org/documents/dcmi-namespace/"),
                    Project.XML       
                    );

                //
                XElement XMedias = new XElement("medias");
                foreach (LDTMedia media in Medias)
                {
                    XMedias.Add(media.XML);
                }
                temp.Add(XMedias);

                //
                XElement XAnnotations = new XElement("annotation");
                foreach (LDTAnnotationsContent annotation in Annotations)
                {
                    XAnnotations.Add(annotation.XML);
                }
                temp.Add(XAnnotations);

                //
                XElement XDisplays = new XElement("displays");
                    foreach(LDTDisplay display in Displays)
                    {
                        XDisplays.Add(display.XML);
                    }
                   temp.Add(XDisplays);

                //
                XElement XEdits = new XElement("edits");
                foreach (LDTEditing edit in Edits)
                {
                    XEdits.Add(edit.XML);
                }
                temp.Add(XEdits);
                return temp;
            }
        }
        
    }
}
