﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class MainVM : BaseMVVM.ViewModel.ViewModel
    {
        private ConsultationViewVM _consultationViewVM;
        public ConsultationViewVM ViewModelConsultationView
        {
            get
            {
                return _consultationViewVM;
            }
            set
            {
                _consultationViewVM = value;
                OnPropertyChanged("ViewModelConsultationView");
            }
        }

        private NavigationBarVM _navigationBarVM;
        public NavigationBarVM ViewModelNavigationBar
        {
            get
            {
                return _navigationBarVM;
            }
            set
            {
                _navigationBarVM = value;
                OnPropertyChanged("ViewModelNavigationBar");
            }
        }

        private HeaderControlVM _headerControlVM;
        public HeaderControlVM ViewModelHeaderControl
        {
            get
            {
                return _headerControlVM;
            }
            set
            {
                _headerControlVM = value;
                OnPropertyChanged("ViewModelHeaderControl");
            }
        }

        private HeaderProductionVM _headerProductionVM;
        public HeaderProductionVM ViewModelHeaderProduction
        {
            get
            {
                return _headerProductionVM;
            }
            set
            {
                _headerProductionVM = value;
                OnPropertyChanged("ViewModelHeaderProduction");
            }
        }

        public MainVM(List<VideoBook> videoBooks)
        {

            InitializeCommands();
            List<VideoBook> SelectedVideoBooks = videoBooks;


            // Initialisation des Components //
            ViewModelConsultationView = new ConsultationViewVM();
            ViewModelNavigationBar = new NavigationBarVM() { ConsultMenuViewModel = new ConsultMenuVM(SelectedVideoBooks) };
            ViewModelHeaderControl = new HeaderControlVM();
            ViewModelHeaderProduction = new HeaderProductionVM();
            //------------------------------------------------------//
        }

        private void InitializeCommands()
        {
            Commands.Initialize();
        }
       
    }
}
