﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Project
    /// </summary>
    public class LDTProject
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// Attribut 
        /// </summary>
        public String User { get; set; }
        /// <summary>
        /// Attribut 
        /// </summary>
        public String Title { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Abstract { get; set;}

        public LDTProject(XElement e)
        {
            if (e.Name != "project")
            {
                throw new Exception("XML node name doesn't match (LDT Project)");
            }
            Id = int.Parse(e.Attribute("id").Value);
            User = e.Attribute("user").Value;
            Title = e.Attribute("title").Value;
            Abstract = e.Attribute("abstract").Value;
        }
        public LDTProject()
        {
            Id = 0;
            User = String.Empty;
            Title = String.Empty;
            Abstract = String.Empty;
        }
        public XElement XML
        {
            get
            {
                return new XElement("project",
                    new XAttribute("id",Id),
                    new XAttribute("user",User),
                    new XAttribute("title",Title),
                    new XAttribute("abstract",Abstract)
                    );
            }
        }
      
    }
}
