﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using System.Collections.Generic;
using SLExtensions.Collections.ObjectModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ProductionTimeLineVM : BaseMVVM.ViewModel.ViewModel
    {


        private bool _isIndexing;
        public bool IsIndexing
        {
            get
            {
                return _isIndexing;
            }
            set
            {
                _isIndexing = value;
                OnPropertyChanged("IsIndexing");
            }
        }

        private VideoBook _newBook;
        private ObservableCollection<VideoSequence>[] _listVideoSequences = new ObservableCollection<VideoSequence>[4];
        public ObservableCollection<VideoSequence>[] ListVideoSequences
        {
            get
            {
                return _listVideoSequences;
            }
            set
            {
                _listVideoSequences = value;
                OnPropertyChanged("ListVideoSequences");
            }
        }
        
        public ObservableCollection<VideoSequence> SelectedVideoSequences
        {
            get
            {
                
                return _listVideoSequences[SelectedChapter];
            }
            set
            {
                _listVideoSequences[SelectedChapter] = value;
                //_newBook.Chapters[SelectedChapter].VideoSequences = value;
                OnPropertyChanged("SelectedVideoSequences");
            }
        }
    
        public VideoChapter[] Chapters
        {
            get
            {
                return _newBook.Chapters;
            }
          
        
        }
        public VideoChapter SelectedBookChapter
        {
            get
            {
                return _newBook.Chapters[SelectedChapter];
            }
        }

        private int _selectedChapter=0;
        public int SelectedChapter
        {
            get
            {
                return _selectedChapter;
            }
            set
            {
                _selectedChapter = value;
                OnPropertyChanged("SelectedChapter");
            }
        }

       
    
        private List<SegmentIndex>[] _listSegmentIndex = new List<SegmentIndex>[4];
        public List<SegmentIndex> SelectedIndex
        {
            get
            {
                return _listSegmentIndex[SelectedChapter];
            }
            set
            {
                _listSegmentIndex[SelectedChapter] = value;
                _newBook.Chapters[SelectedChapter].Index = value;
                OnPropertyChanged("SelectedIndex");
            }
        }

        private VideoChapterType _selectedChapterType;
        public VideoChapterType SelectedChapterType
        {
            get
            {
                return _selectedChapterType;
            }
            set
            {
                _selectedChapterType = value;
                OnPropertyChanged("SelectedChapterType");
            }
        }
 
      
        public ProductionTimeLineVM()
        {
            _newBook = new VideoBook();
            _listVideoSequences = new ObservableCollection<VideoSequence>[4]
            {
                new ObservableCollection<VideoSequence>(),
                new ObservableCollection<VideoSequence>(),
                new ObservableCollection<VideoSequence>(),
                new ObservableCollection<VideoSequence>()
            };
           // PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(ProductionTimeLineVM_PropertyChanged);
           // SelectedVideoSequences = new ObservableCollection<VideoSequence>();
            Commands.ProductionTimeLine.EditorPartSelected.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartSelected_Executed);
            Commands.ProductionTimeLine.EditorPartFinished.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartFinished_Executed);
            _listVideoSequences[0].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listVideoSequences[1].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listVideoSequences[2].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listVideoSequences[3].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
      
        }

        void SelectedVideoSequences_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            Commands.ProductionView.VideoRecordUpdated.Execute();
        }

        void ProductionTimeLineVM_PropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            Commands.ProductionView.VideoRecordUpdated.Execute();
        }

        void EditorPartFinished_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedChapter = -1;
        }

        void EditorPartSelected_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
           
            SelectedChapter = (int)((HeaderProductionEventArgs)e.Source).ChapterType;
            SelectedChapterType = ((HeaderProductionEventArgs)e.Source).ChapterType ;
            IsIndexing = ((HeaderProductionEventArgs)e.Source).IsIndexPart;
        }
    }
}
