﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Controls.ViewModel;
using SLExtensions.Collections.ObjectModel;
namespace Iri.Modernisation.Controls.View
{
  
	public partial class ProductionTimeLine : UserControl
	{
        public static double ScaleTime
        {
            get
            {
                return 0.0001;
            }
        }
		public ProductionTimeLine()
		{
			// Required to initialize variables
			InitializeComponent();
            Commands.ProductionView.VideoRecordUpdated.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(VideoRecordUpdated_Executed);
             Commands.Action.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Action_Executed);
          
		}

        void VideoRecordUpdated_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
          UpdateElements();
        }
     

        void Action_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            AddSequenceButton.Content = ((MouseEventArgs)e.Parameter).GetPosition(this).X;
        }
        public void UpdateElements()
        {
            if (DataContext != null)
            {
                VideoTimeStrip.Children.Clear();
                int intChapter = 0;
                foreach(ObservableCollection<VideoSequence> Ocvs in  ((ProductionTimeLineVM)this.DataContext).ListVideoSequences)
                {
                    foreach (VideoSequence Vs in Ocvs)
                    {
                        CustomableVideoElement _temp = new CustomableVideoElement()
                        {
                            DataContext = new CustomableVideoElementVM(Vs)
                            {
                                Chapter = (VideoChapterType)intChapter
                            },
                        };
                        _temp.MouseMove += new MouseEventHandler(CustomableVideoElement_MouseMove);
                        _temp.MouseLeftButtonDown += new MouseButtonEventHandler(CustomableVideoElement_MouseLeftButtonDown);
                        _temp.MouseLeftButtonUp += new MouseButtonEventHandler(CustomableVideoElement_MouseLeftButtonUp);

                        VideoTimeStrip.Children.Add(_temp);// TODO: Add event handler implementation here.

                    }
                    intChapter++;
                }
                
            }
        }
        private void AddSequenceButton_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            Random rndNumbers = new Random();
            if (((ProductionTimeLineVM)this.DataContext).SelectedChapter != -1)
            {
                if(!((ProductionTimeLineVM)DataContext).IsIndexing)
                {

                CustomableVideoElement _temp = new CustomableVideoElement()
                                         {
                                             DataContext = new CustomableVideoElementVM(new VideoSequence()
                                             {

                                                 RunTime = new TimeSpan(0, rndNumbers.Next(10, 60), 0),
                                                 BeginTrim = new TimeSpan(0, 0, 0),
                                                 EndTrim = new TimeSpan(0, 0, 0),

                                             }) { Chapter = ((ProductionTimeLineVM)this.DataContext).SelectedChapterType},
                                             // Width = 200
                                         };
                
                _temp.MouseMove += new MouseEventHandler(CustomableVideoElement_MouseMove);
                _temp.MouseLeftButtonDown += new MouseButtonEventHandler(CustomableVideoElement_MouseLeftButtonDown);
                _temp.MouseLeftButtonUp += new MouseButtonEventHandler(CustomableVideoElement_MouseLeftButtonUp);
                
                   VideoTimeStrip.Children.Add(_temp  );// TODO: Add event handler implementation here.
                }
                else
                {
                    VideoChapter vc = ((ProductionTimeLineVM)DataContext).SelectedBookChapter;
                    PolemicElementControl an = new PolemicElementControl();
                    an.DataContext = new PolemicElementVM(new SegmentIndex(vc)
                        {
                            TimerIn = TimeSpan.Zero,
                            Duration = new TimeSpan(0, rndNumbers.Next(10, 60), 0),
                            Chapter = vc,

                        });
                    
                        //((ProductionTimeLineVM)DataContext).SelectedBookChapter);
                    AnnotationTimeStrip.Children.Add(an);
                }
            }
        }

        

        private void slider_ValueChanged(object sender, System.Windows.RoutedPropertyChangedEventArgs<double> e)
        {
        	 AddSequenceButton.Content = e.NewValue;
			// TODO: Add event handler implementation here.
        }



        private Point _comePoint; 
        private bool _isTrimRightCapturated = false;
        private bool _isTrimLeftCapturated = false;

        private CustomableVideoElement _selected;
        void CustomableVideoElement_MouseMove(object sender, MouseEventArgs e)
        {

            
            if (_isTrimRightCapturated && ((CustomableVideoElement)sender).CaptureMouse())
            {
                ((CustomableVideoElement)sender).TrimRight = _comePoint.X  - e.GetPosition(((CustomableVideoElement)sender)).X;
                _comePoint = e.GetPosition(((CustomableVideoElement)sender));
            }
            else if (_isTrimLeftCapturated && ((CustomableVideoElement)sender).CaptureMouse())
            {
                ((CustomableVideoElement)sender).TrimLeft = e.GetPosition(((CustomableVideoElement)sender)).X - _comePoint.X;
                _comePoint = e.GetPosition(((CustomableVideoElement)sender));
            }
           
        }
        void CustomableVideoElement_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            _isTrimRightCapturated = false;
            _isTrimLeftCapturated = false;
        }

        void CustomableVideoElement_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            _selected = ((CustomableVideoElement)sender);
            if (e.GetPosition(((CustomableVideoElement)sender)).X >= ((CustomableVideoElement)sender).Width - 5)
            {
                _comePoint = e.GetPosition(((CustomableVideoElement)sender));
                _isTrimRightCapturated = true;
            }
            if (e.GetPosition(((CustomableVideoElement)sender)).X <= 5)
            {
                _comePoint = e.GetPosition(((CustomableVideoElement)sender));
                _isTrimLeftCapturated = true;
            }
        }

        private void DeleteSequenceButton_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            VideoTimeStrip.Children.Remove(_selected);
        }
	}
}