﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Controls.View
{
	public partial class ClickMenu : UserControl
	{


        public PolemicElement SelectedElement
        {
            get { return (PolemicElement)GetValue(SelectedElementProperty); }
            set { SetValue(SelectedElementProperty, value); }
        }

        // Using a DependencyProperty as the backing store for SelectedElement.  This enables animation, styling, binding, etc...   
        public static readonly DependencyProperty SelectedElementProperty =
            DependencyProperty.Register("SelectedElement", typeof(Iri.Modernisation.Data.Models.PolemicElement), typeof(ClickMenu), null);


		public ClickMenu()
		{
			// Required to initialize variables
			InitializeComponent();
            /*Animation*/
            Commands.PolemicElement.ElementSelected.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(MenuClick_Executed);
            _annoterPanel.ClickMenuItemHooverSelected += new EventHandler<ClickMenuItemHooverEventArgs>(Item_ClickMenuItemHooverSelected);
            _contextualiserPanel.ClickMenuItemHooverSelected += new EventHandler<ClickMenuItemHooverEventArgs>(Item_ClickMenuItemHooverSelected);
            _localiserItem.ClickMenuItemHooverSelected += new EventHandler<ClickMenuItemHooverEventArgs>(Item_ClickMenuItemHooverSelected);
            _copierItem.ClickMenuItemHooverSelected += new EventHandler<ClickMenuItemHooverEventArgs>(Item_ClickMenuItemHooverSelected);
            _chutierItem.ClickMenuItemHooverSelected += new EventHandler<ClickMenuItemHooverEventArgs>(Item_ClickMenuItemHooverSelected);
            
            /*Action*/
           Commands.Action.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Action_Executed);
           _localiserItem.ClickMenuItemSelected += Commands.Action.Execute;
            _copierItem.ClickMenuItemSelected += Commands.Action.Execute;
            _chutierItem.ClickMenuItemSelected += Commands.ClickMenu.AddToRefChutier.Execute;
            _contextualiserPanel._adhesionItem.ClickMenuItemSelected += Commands.Action.Execute;
            _contextualiserPanel._polemicItem.ClickMenuItemSelected += Commands.Action.Execute;
            _contextualiserPanel._questionItem.ClickMenuItemSelected += Commands.Action.Execute;
            _contextualiserPanel._referenceItem.ClickMenuItemSelected += Commands.Action.Execute;
            _annoterPanel._videoItem.ClickMenuItemSelected += Commands.Action.Execute;
            _annoterPanel._textItem.ClickMenuItemSelected += Commands.ClickMenu.CreateNewTextualAnnotation.Execute;

        }

        void Action_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            MessageBox.Show("Action - Command:"+((ClickMenuItem)e.Parameter).Title);
        }

        void ClickMenuItemSelected(object sender, ClickMenuItemSelectedEventArgs e)
        {
            MessageBox.Show("Action");
              }

    

        

        void MenuClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
           Visibility = Visibility.Visible;
           SelectedElement = (PolemicElement)e.Source;
           textBlock.Text = ((PolemicElement)e.Source).Title;
        }

        void Item_ClickMenuItemHooverSelected(object sender, ClickMenuItemHooverEventArgs e)
        {
            ClickMenuItem temp = (ClickMenuItem)sender;
            textBlock.Text = " > "+temp.Title;
        }

        private void LayoutRoot_MouseLeftButtonUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
        	 Visibility = Visibility.Collapsed;
    
        }

		
	}
}