﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Controls.View;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class CustomableIndexElementVM : BaseMVVM.ViewModel.ViewModel
    {
        public CustomableIndexElementVM(SegmentIndex paramSeg)
        {

            _segmentIndex = paramSeg;

            _timerIn = paramSeg.TimerIn;
            _timerOut = paramSeg.TimerOut;
  

            OnPropertyChanged("Duration");
        }

        private SegmentIndex _segmentIndex;
        public SegmentIndex SegmentIndex
        {
            get
            {
                return _segmentIndex;
            }
        }

        private TimeSpan _timerIn;
        public TimeSpan TimerIn
        {
            get
            {
                return _timerIn;
            }
            set
            {
                _timerIn = value;
                _segmentIndex.TimerIn = value;
                OnPropertyChanged(String.Empty);
            }
        }

        private TimeSpan _timerOut;
        public TimeSpan TimerOut
        {
            get
            {
                return _timerOut;
            }
            set
            {
                _timerOut = value;
                _segmentIndex.TimerOut = value;
                OnPropertyChanged(String.Empty);
            }
        }

        
        public double Duration
        {
            get
            {
                //MessageBox.Show(((TimeSpan)(TimerOut - TimerIn)).TotalMilliseconds.ToString());
                return ((TimeSpan)(TimerOut - TimerIn)).TotalMilliseconds * ProductionTimeLine.ScaleTime;

            }
            
        }

        private VideoChapterType _chapter;
        public VideoChapterType Chapter
        {
            get
            {
                return _segmentIndex.Chapter.Type;
            }
            set
            {
                _chapter = value;
                OnPropertyChanged("Chapter");
            }
        }

      
    }
}
