﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.ViewModel;
namespace Iri.Modernisation.Controls.View
{
	public partial class VideoViewer : UserControl
	{


     
        public System.Windows.Threading.DispatcherTimer VideoPositionTimer = new System.Windows.Threading.DispatcherTimer();
       
        public String MediaSource
        {
            get
            { 
                return (String)GetValue(SourceProperty); 
            }
            set 
            { 
                SetValue(SourceProperty, value);
                if(DataContext != null)
                ((VideoViewerVM)DataContext).Source = value;
            }
        }

        // Using a DependencyProperty as the backing store for Source.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty SourceProperty =
            DependencyProperty.Register("MediaSource", typeof(String), typeof(VideoViewer), new PropertyMetadata(""));

        private bool _isPlayed  = false;
		public VideoViewer()
		{
			// Required to initialize variables
			InitializeComponent();   /// <summary>
            VideoPositionTimer.Interval = new System.TimeSpan(0, 0, 0, 0, 1000); 
            VideoPositionTimer.Tick += new EventHandler(VideoPositionTimer_Tick);
            Commands.GoToTime.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(GoToTime_Executed);
            Commands.VideoViewer.Pause.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Pause_Executed);
            Commands.VideoViewer.Play.Executed +=new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Play_Executed);
		}

        void GoToTime_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            VideoScreen.Position = TimeSpan.FromMilliseconds((double)e.Parameter);
        }

        void VideoPositionTimer_Tick(object sender, EventArgs e)
        {
            if (_isPlayed) 
            {
                if(Tick!=null)
                {
                    Tick(this, new VideoViewerEventArgs(VideoScreen.Position));
                }
                ((VideoViewerVM)DataContext).LaunchTick(VideoScreen.Position);
            }
           //Commands.VideoViewer.SendPosition.Execute(VideoScreen.Position);
        }
        public void ChangePosition(TimeSpan TS)
        {
            VideoScreen.Position = TS;
            
        }
        void Pause_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            VideoScreen.Pause();
            _isPlayed = false;
            VideoPositionTimer.Stop();
            if (VideoPositionTimer.IsEnabled)
            {
                MessageBox.Show("Click Time IS NOT STOPPED");
            }
        }

        void Play_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (e.Parameter == DataContext || e.Parameter == null)
            {
                _isPlayed = true;
                VideoScreen.Play();
                VideoPositionTimer.Start();
            }
        }

		private void VideoScreen_MediaFailed(object sender, System.Windows.ExceptionRoutedEventArgs e)
		{
			MessageBox.Show(e.ErrorException.ToString());
		}

		private void VideoScreen_CurrentStateChanged(object sender, System.Windows.RoutedEventArgs e)
		{
            
		}

		private void VideoScreen_MarkerReached(object sender, System.Windows.Media.TimelineMarkerRoutedEventArgs e)
		{
            MessageBox.Show("toto");
		}
        public event EventHandler<VideoViewerEventArgs> Tick;
	}
    public class VideoViewerEventArgs: EventArgs
    {

        public TimeSpan Position { get; set; }
        public VideoViewerEventArgs(TimeSpan pos)
        {
            Position = pos;
        }
    }
}