﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Element
    /// </summary>
    public class LDTElement
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Id { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public long Begin { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public long Dur { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Author { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public DateTime Date { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public int Color { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Src { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Title { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Abstract { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Audio { get; set; }
        /// <summary>
        /// Elements
        /// </summary>
        public List<String> Tags { get; set; }

        public LDTElement(XElement e)
        {
            Tags = new List<String>();

            Id = e.Attribute("id").Value;
            Begin = long.Parse(e.Attribute("begin").Value);
            Dur = long.Parse(e.Attribute("dur").Value);
            Author = e.Attribute("author").Value;
            Date = DateTime.Parse(e.Attribute("date").Value);
            Color = int.Parse(e.Attribute("color").Value);
            Src = e.Attribute("src").Value;
            Title = e.Element("title").Value;
            Abstract = e.Element("abstract").Value;
            Audio = e.Element("audio").Value;
            foreach (XElement Str in e.Element("tags").Elements())
            {
                Tags.Add(Str.Value);
            }
        }

        public XElement XML
        {
            get
            {
                XElement temp = new XElement("element",
                    new XAttribute("id",Id),
                    new XAttribute("begin",Begin),
                    new XAttribute("dur",Dur),
                    new XAttribute("author",Author),
                    new XAttribute("date",Date.ToString("")),
                    new XAttribute("color",Color),
                    new XAttribute("src",Src),
                    new XElement("title",Title),
                    new XElement("abstract",Abstract),
                    new XElement("audio",Audio)
                    );
                XElement XTags = new XElement("tags");
                foreach (String Tag in Tags)
                {
                    XTags.Add(new XElement("tag", Tag));
                }
                temp.Add(XTags);
                return temp;
            }
        }
    }
}
