﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.ViewModel;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Controls.View
{
	public partial class HeaderProduction : UserControl
	{
		public HeaderProduction()
		{
			// Required to initialize variables
			InitializeComponent();
            ModernisationEditionController.Active();
            ModernisationEditionController.Text = Iri.Modernisation.Lang.LangResource.AnnotationMakerTitle;

            ModerniteEditionController.Text = "Edition";
            ModerniteIndexController.Text = "Indexation";
            PostModerniteEditionController.Text = "Edition";
            PostModerniteIndexController.Text = "Indexation";
            OuvertureEditionController.Text = "Edition";
            OuvertureIndexController.Text = "Indexation";

            /////////////////////////--
            ModernisationEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);
            ModernisationIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);
           
            ModerniteEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);
            ModerniteIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);

            PostModerniteEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);
            PostModerniteIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);

            OuvertureEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);
            OuvertureIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(HeaderProductionPartSelected);
            //////////////////////
                ModernisationEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(ModernisationEditionController_HeaderProductionPartSelected);
                ModernisationIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(ModernisationIndexController_HeaderProductionPartSelected);

                ModerniteEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(ModerniteEditionController_HeaderProductionPartSelected);
                ModerniteIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(ModerniteIndexController_HeaderProductionPartSelected);

                PostModerniteEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(PostModerniteEditionController_HeaderProductionPartSelected);
                PostModerniteIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(PostModerniteIndexController_HeaderProductionPartSelected);

                OuvertureEditionController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(OuvertureEditionController_HeaderProductionPartSelected);
                OuvertureIndexController.HeaderProductionPartSelected += new EventHandler<HeaderProductionPartControlerEventArgs>(OuvertureIndexController_HeaderProductionPartSelected);
            //////////////////////
            ModernisationEditionController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(ModernisationEditionControler_HeaderProductionPartFinished);
            ModernisationIndexController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(ModernisationIndexControl_HeaderProductionPartFinished);
            
            ModerniteEditionController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(ModerniteEditionControler_HeaderProductionPartFinished);
            ModerniteIndexController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(ModerniteIndexController_HeaderProductionPartFinished);

            PostModerniteEditionController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(PostModerniteEditionController_HeaderProductionPartFinished);
            PostModerniteIndexController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(PostModerniteIndexController_HeaderProductionPartFinished);

            OuvertureEditionController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(OuvertureEditionController_HeaderProductionPartFinished);
            OuvertureIndexController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(OuvertureIndexController_HeaderProductionPartFinished);
        }

        void OuvertureIndexController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            if (SelectedPart != null)
            {
                SelectedPart(sender, new HeaderProductionEventArgs(VideoChapterType.Ouverture, true));
            }
        }

        void OuvertureEditionController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            if (SelectedPart != null)
            {
                SelectedPart(sender, new HeaderProductionEventArgs(VideoChapterType.Ouverture, false));
            }
        }

        void PostModerniteIndexController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            if (SelectedPart != null)
            {
                SelectedPart(sender, new HeaderProductionEventArgs(VideoChapterType.Postmodernite, true));
            }
        }

        void PostModerniteEditionController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            if (SelectedPart != null)
            {
                SelectedPart(sender, new HeaderProductionEventArgs(VideoChapterType.Postmodernite, false));
            }
        }

        void ModerniteIndexController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            if (SelectedPart != null)
            {
                SelectedPart(sender, new HeaderProductionEventArgs(VideoChapterType.Modernite, true));
            }
        }

        void ModerniteEditionController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
              if (SelectedPart!=null)
           {
                SelectedPart(sender,new HeaderProductionEventArgs(VideoChapterType.Modernite,false));
           }
        }

        void ModernisationIndexController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
           if (SelectedPart!=null)
           {
                SelectedPart(sender,new HeaderProductionEventArgs(VideoChapterType.Modernisation,true));
           }
        }

        void ModernisationEditionController_HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            if (SelectedPart!=null)
           {
                SelectedPart(sender,new HeaderProductionEventArgs(VideoChapterType.Modernisation,false));
           }
        }

        void OuvertureIndexController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap04IndexingOkClick.Execute();
            if (FinishedPart != null)
            {
                FinishedPart(sender,new HeaderProductionEventArgs());
            }

        }

        void PostModerniteIndexController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap03IndexingOkClick.Execute();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
        }

        void ModerniteIndexController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap02IndexingOkClick.Execute();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
        }

        void OuvertureEditionController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap04EditingOkClick.Execute();
            OuvertureIndexController.Active();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
        }

        void PostModerniteEditionController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap03EditingOkClick.Execute();
            PostModerniteIndexController.Active();
            OuvertureEditionController.Active();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
        }

        void ModerniteEditionControler_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {

            Commands.HeaderProduction.Chap02EditingOkClick.Execute();
            ModerniteIndexController.Active();
            PostModerniteEditionController.Active();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
        }

        void ModernisationIndexControl_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap01IndexingOkClick.Execute();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
        }

        void HeaderProductionPartSelected(object sender, HeaderProductionPartControlerEventArgs e)
        {
            ModernisationEditionController.UnSelect();
            ModernisationIndexController.UnSelect();
           
            ModerniteEditionController.UnSelect();
            ModerniteIndexController.UnSelect();

            PostModerniteEditionController.UnSelect();
            PostModerniteIndexController.UnSelect();

            OuvertureEditionController.UnSelect();
            OuvertureIndexController.UnSelect();
            ((HeaderProductionPartControler)sender).Select();
        }

        void ModernisationEditionControler_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            Commands.HeaderProduction.Chap01EditingOkClick.Execute();
            ModernisationIndexController.Active();
			ModerniteEditionController.Active();
            if (FinishedPart != null)
            {
                FinishedPart(sender, new HeaderProductionEventArgs());
            }
           
        }
        public event EventHandler<HeaderProductionEventArgs> SelectedPart;
        public event EventHandler<HeaderProductionEventArgs> FinishedPart;

	}
    public class HeaderProductionEventArgs : EventArgs
    {
        public VideoChapterType ChapterType;
        public bool IsIndexPart;
        public HeaderProductionEventArgs()
        {
        }
        public HeaderProductionEventArgs(VideoChapterType chapterType,bool isIndexpPrt)
        {
            ChapterType = chapterType;
            IsIndexPart = isIndexpPrt;
        }

    }
}