﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM;
using Iri.Modernisation.Data.Models;
using System.Collections.Generic;
using System.Linq;
using Iri.Modernisation.BaseMVVM.Commands;

namespace Iri.Modernisation.Controls.ViewModel
{
    public class ProductionEditorVM: BaseMVVM.ViewModel.ViewModel
    {
        private CaptureSource _captureSource;
        public CaptureSource CaptureSource
        {
            get
            {
                return _captureSource;
            }
            set
            {
                _captureSource = value;
                OnPropertyChanged("CaptureSource");
            }
        }

        private VideoViewerVM _videoViewerVM;
        public VideoViewerVM ViewModelVideoViewer
        {
            get
            {
                return _videoViewerVM;
            }
            set
            {
                _videoViewerVM = value;
                OnPropertyChanged("ViewModelVideoViewer");
            }
        }

        private PolemicElement _selectedSegmentIndex;

        private String _selectedIndexTitle;
        public String SelectedIndexTitle
        {
            get
            {
                return _selectedIndexTitle;
            }
            set
            {
                _selectedIndexTitle = value;
                _selectedSegmentIndex.Title = value;
                OnPropertyChanged("SelectedIndexTitle");
            }
        }

        private String _selectedIndexDescription;
        public String SelectedIndexDescription
        {
            get
            {
                return _selectedIndexDescription;
            }
            set
            {
                _selectedIndexDescription = value;
                _selectedSegmentIndex.Description = value;
                OnPropertyChanged("SelectedIndexDescription");
            }
        }

        private List<String> _selectedIndexTags = new List<String>();
        public String SelectedIndexTags
        {
            get
            {
                try
                {
                    return String.Join(",", _selectedIndexTags.ToArray());
                }
                catch
                {
                    return String.Empty;
                }
            }
            set
            {
                String val = (String)value;
                _selectedIndexTags = val.Split(',').ToList();
                _selectedSegmentIndex.Tags = val.Split(',').ToList();
                OnPropertyChanged("Tags");


            }
        }

        private bool _isRecordMode;
        public bool IsRecordMode
        {
            get
            {
                return _isRecordMode;
            }
            set
            {
                _isRecordMode = value;
                IsEditMode = !value;
                if (value)
                {
                    

                }
                else
                {
              
                }
                OnPropertyChanged("IsRecordMode");
              
            }
        }

        private bool _isEditMode;
        public bool IsEditMode
        {
            get
            {
                return _isEditMode;
            }
            set
            {
                _isEditMode = value;
                OnPropertyChanged("IsEditMode");
            }
        }

     
        private bool _isEditableIndex;
        public bool IsEditableIndex
        {
            get
            {
                return _isEditableIndex;
            }
            set
            {
                _isEditableIndex = value;
                OnPropertyChanged("IsEditableIndex");
            }
        }

        public ProductionEditorVM()
        {
            InitializeCommands();
        }
        public ProductionEditorVM(VideoSequence Vs)
        {
            ViewModelVideoViewer = new VideoViewerVM(true, false)
                {
                   Source = Vs.Path
                };
            ViewModelVideoViewer.AutoPlay = false;
            IsRecordMode = false;
            InitializeCommands();
        }
        private void InitializeCommands()
        {

            Commands.ProductionTimeLine.IndexSelected.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(IndexSelected_Executed);

       
        }
        void IndexSelected_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
           
            IsEditableIndex = (bool)e.Parameter;
            _selectedSegmentIndex = (SegmentIndex)e.Source;
            _selectedIndexTitle = _selectedSegmentIndex.Title;
            _selectedIndexTags = _selectedSegmentIndex.Tags;
            _selectedIndexDescription = _selectedSegmentIndex.Description;
            OnPropertyChanged(String.Empty);
        }
    }
}
