﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class HeaderProductionVM : BaseMVVM.ViewModel.ViewModel
    {

        private List<HeaderProductionChapterVM> _productionChapters;
        public List<HeaderProductionChapterVM> ProductionChapters
        {
            get
            {
                return _productionChapters;
            }
            set
            {
                _productionChapters = value;
                OnPropertyChanged("ProductionChapters");
            }
        }

        private HeaderProductionChapterVM _selectedChapter;
        public HeaderProductionChapterVM SelectedChapter
        {
            get
            {
                return _selectedChapter;
            }
            set
            {
                if (_selectedChapter != null)
                {
                    _selectedChapter.HighLight = false;
                }

                _selectedChapter = value;
            
                    value.HighLight = true;
                    if (Change != null)
                        Change(this, new HeaderProductionVMArgs(SelectedChapter));
              
                
                OnPropertyChanged("SelectedChapter");
            }

        }
      
        public bool IsVideoBookComplete
        {
            get
            {
                bool test = true;
                foreach(HeaderProductionChapterVM Hpcvm in ProductionChapters )
                {
                    test = Hpcvm.Indexing && test; 
                }
                return test;
            }
        }
        private String _instruction;
        /// <summary>
        /// Instruction
        /// </summary>
        public String Instruction
        {
            get
            {
                return _instruction;
            }
            set
            {
                _instruction = value;
                OnPropertyChanged("Instruction");
            }
        }
        public HeaderProductionVM()
        {
            _productionChapters = new List<HeaderProductionChapterVM>();
            HeaderProductionChapterVM temp = null;
            foreach (VideoChapterDescription Vcd in FactoryVideoLivre.VideoChapterDescriptions)
            {
                temp = new HeaderProductionChapterVM(Vcd);
                temp.Ended +=new HeaderProductionChapterVM.EndedDelegate(temp_Ended);
                temp.EditEnded += new HeaderProductionChapterVM.EditEndedDelegate(temp_EditEnded);
                temp.HighLight = false;
               _productionChapters.Add(temp);
               if(_productionChapters.Count > 1)
               {
                   _productionChapters[_productionChapters.Count - 2].EditEnded+=new HeaderProductionChapterVM.EditEndedDelegate(temp.Enable);
                   
               }
              
                
            }
            _instruction = Iri.Modernisation.Controls.Resources.HeaderProduction.InstructionTextRessource.Introduction;
           
            InitializeCommands();
            ProductionChapters[0].Enable();
          
    
        }

        void temp_EditEnded()
        {
            if(Change!=null)
            Change(this,new HeaderProductionVMArgs(SelectedChapter));
        }
       
       

        void temp_Ended()
        {
            OnPropertyChanged("IsVideoBookComplete");
            if (Change != null)
                Change(this, new HeaderProductionVMArgs(SelectedChapter));
        }
        private void InitializeCommands()
        {
        }
        public event EventHandler<HeaderProductionVMArgs> Change;
     
       
    }
    public class HeaderProductionVMArgs : EventArgs
    {
  
        public HeaderProductionChapterVM ChapterHeader { get; private set; }

        public HeaderProductionVMArgs( HeaderProductionChapterVM chapterHeader)
        {
            ChapterHeader = chapterHeader;
          

           
        }
    }
}
