﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using System.Windows.Data;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.Converter;



namespace Iri.Modernisation.Controls.View
{
    public partial class ContextualLinkBinder : UserControl
    {

        public PolemicTypeDescription PolemicType
        {
            get { return (PolemicTypeDescription)GetValue(_polemicType); }
            set
            {
                
                SetValue(_polemicType, value);
                //PolemicTypeColorConverter converter = new PolemicTypeColorConverter();
                path9020.Stroke = new SolidColorBrush(value.Color);

            }
        }

        public static readonly DependencyProperty _polemicType =
            DependencyProperty.Register("PolemicType", typeof(PolemicTypeDescription), typeof(ContextualLinkBinder), new PropertyMetadata(new PropertyChangedCallback(PolemicTypeChanged)));
        private static void PolemicTypeChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e)
        {

            ((ContextualLinkBinder)sender).path9020.Stroke = new SolidColorBrush((((PolemicTypeDescription)e.NewValue)).Color);
        }

        /* public Brush ArrowColor
         {
             get { return path9020.Stroke; }
             set { path9020.Stroke = value; }
         }*/
        public ContextualLinkBinder()
        {
            // Required to initialize variables
              InitializeComponent();
              MouseLeftButtonDown += Commands.ContextualBinderLayer.BeginBind.Execute;
              MouseLeftButtonUp += new MouseButtonEventHandler(ContextualLinkBinder_MouseLeftButtonUp);
              


        }

        void ContextualLinkBinder_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            Commands.ContextualBinderLayer.BeginBind.Execute(sender, null);
        }
        public ContextualLinkBinder(ContextualLinkBinder copy)
        {
            InitializeComponent();
            PolemicType = copy.PolemicType;
        }
    }
    
}