﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Data.LDTClass;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using System.Collections.ObjectModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel de ConsultationView
    /// </summary>
    public class ConsultationViewVM : BaseMVVM.ViewModel.ViewModel
    {
        
        private PolemicElement _selectedElement;
        /// <summary>
        /// PolemicElement sélectionné
        /// </summary>
        public PolemicElement SelectedElement
        {
            get
            {
                return _selectedElement;
            }
            set
            {
                _selectedElement = value;
                OnPropertyChanged("SelectedElement");
            }
        }

        private ObservableCollection<BookTimeLineVM> _selectedVideoBooks;
        /// <summary>
        /// Liste des Livres Sélectionnés
        /// </summary>
        public ObservableCollection<BookTimeLineVM> SelectedVideoBooks
        {
            get
            {

                return _selectedVideoBooks;
            }
            set
            {
                _selectedVideoBooks = value;
                OnPropertyChanged("SelectedVideoBooks");
            }
        }

        private int _selectedVideoBookIndex=-1;
        /// <summary>
        /// Index du livre sélectionné
        /// </summary>
        public int SelectedVideoBookIndex
        {
            get
            {
                return _selectedVideoBookIndex;
            }
            set
            {
                _selectedVideoBookIndex= value;
                OnPropertyChanged("SelectedVideoBookIndex");
                if (_selectedVideoBooks.Count > value && value >= 0)
                {
                    ConsultationBookViewContextMenu.SelectedBookVM = (_selectedVideoBooks[value]);
                }
                else
                {
                    ConsultationBookViewContextMenu.SelectedBookVM = null;
                }
               
            }
        }

        private ConsultationBookViewVM _consultationBookViewContextMenu;
        /// <summary>
        /// ViewModel de ConsultationBook
        /// </summary>
        public ConsultationBookViewVM ConsultationBookViewContextMenu
        {
            get
            {
                return _consultationBookViewContextMenu;
            }
            set
            {
                _consultationBookViewContextMenu = value;
                OnPropertyChanged(null);
            }
        }
        /// <summary>
        /// Loader pour chargement à la volée des VideoLivres selectionnés
        /// </summary>
        //private Loader<VideoBook> _loaderVideoBook { get; set; }
        private VideoBookLoader _loaderVideoBook { get; set; }
        private AnnotationMakerVM _annotationMakerVM;
        /// <summary>
        /// ViewModel de AnnotationMaker
        /// </summary>
        public AnnotationMakerVM ViewModelAnnotationMaker
        {
            get
            {
                return _annotationMakerVM;
            }
            set
            {
                _annotationMakerVM = value;
                OnPropertyChanged("ViewModelAnnotationMaker");
            }
        }

        private void InitializeCommands()
        {
            Commands.ClickMenu.CreateNewTextualAnnotation.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CreateNewTextualAnnotation_Executed);
            Commands.ConsultMenu.ClickBook.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickBook_Executed);
            Commands.PolemicElement.SelectPolemicElement.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(SelectPolemicElement_Executed);
            Commands.AnnotationMaker.NewAnnotationFinished.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(NewAnnotationFinished_Executed);
            Commands.BookTimeLine.LeftClickOnElement.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(LeftClickOnElement_Executed);
            Commands.BookTimeLine.CloseBookTimeLine.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CloseBookTimeLine_Executed);
        }

        void CloseBookTimeLine_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedVideoBooks.Remove((BookTimeLineVM)e.Parameter);
            BookDeleted(this,new ConsultationVieVMSelectBookArg(((BookTimeLineVM)e.Parameter).SelectedBook));
        }

        void LeftClickOnElement_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            TimeSpan TimeToGo = (TimeSpan)e.Parameter;
            PolemicElementVM ClickedElement = (PolemicElementVM)e.Source;
            if(ConsultationBookViewContextMenu.SelectedBook == ClickedElement.Chapter.Book)
            {
                ConsultationBookViewContextMenu.ActualVideoSourceVM.GoTo(TimeToGo);
            }
        }

        void NewAnnotationFinished_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            Annotation createdAnnotation = ((Annotation)e.Parameter);
            PolemicElement refElement = ((PolemicElement)e.Source);
           // refElement.Chapter.Annotations.Add(createdAnnotation);
            //refElement.Chapter.Book.Save();

           
        }

        List<String> InDownloadFile { get; set; }

        /// <summary>
        /// Evenement lors d'un click sur un livre de la liste
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ClickBook_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {

            bool CanAdd = true;
            VideoBook clickedVideoBook = ((VideoBook)e.Parameter);
            //On regarde si le VideoLivre qu'on à choisis n'est pas déjà dans la liste des VideoLivres sélectionné
            foreach (BookTimeLineVM BookTLVM in SelectedVideoBooks)
            {
                if (BookTLVM.SelectedBook.LdtPath == clickedVideoBook.LdtPath)
                {
                    CanAdd = false;
                }
            }
            if (CanAdd && !InDownloadFile.Contains(clickedVideoBook.LdtPath))
            {
                //Préparation du loader
               /* _loaderVideoBook = new Loader<VideoBook>(LDTFileReader.ConvertToVideoBook);
                _loaderVideoBook.LoaderFinished += new EventHandler<EventArgs>(LoaderVideoBook_LoaderFinished);
                _loaderVideoBook.Load(((VideoBook)e.Parameter).LdtPath);*/
                InDownloadFile.Add(clickedVideoBook .LdtPath);
                _loaderVideoBook = new VideoBookLoader();
                _loaderVideoBook.LoaderFinished += new EventHandler<LoaderEventArgs<VideoBook>>(_loaderVideoBook_LoaderFinished);
                _loaderVideoBook.Load(clickedVideoBook.LdtPath);
            }
            

        }

        void _loaderVideoBook_LoaderFinished(object sender, LoaderEventArgs<VideoBook> e)
        {
            VideoBook addedVideoBook = ((LoaderEventArgs<VideoBook>)e).CreatedObject;
            BookTimeLineVM temp = new BookTimeLineVM(addedVideoBook);
            temp.ViewModelVideoViewer = ConsultationBookViewContextMenu.ActualVideoSourceVM;
            SelectedVideoBooks.Add(temp);
            InDownloadFile.Remove(addedVideoBook.LdtPath);

            if(BookDownloaded!=null)
            BookDownloaded(this,new ConsultationVieVMSelectBookArg(addedVideoBook));
        }

        public event EventHandler<ConsultationVieVMSelectBookArg> BookDownloaded;
        public event EventHandler<ConsultationVieVMSelectBookArg> BookDeleted;

        
        private void CreateNewTextualAnnotation_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            ViewModelAnnotationMaker.RefElement=SelectedElement;
            
        }
        public ConsultationViewVM()
        {
            InitializeCommands();
            InDownloadFile = new List<string>();
            _consultationBookViewContextMenu = new ConsultationBookViewVM();
            ViewModelAnnotationMaker = new AnnotationMakerVM();
            SelectedVideoBooks = new SLExtensions.Collections.ObjectModel.ObservableCollection<BookTimeLineVM>();
        }

        private void SelectPolemicElement_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedElement= (PolemicElement)e.Parameter;
            try
            {
                ConsultationBookViewContextMenu.SelectedIndex = (SegmentIndex)SelectedElement;
            }
            catch
            {
            }
        }
    }
    public class ConsultationVieVMSelectBookArg : EventArgs
    {
        public VideoBook Book {get;private set;}
        public ConsultationVieVMSelectBookArg (VideoBook book)
        {
            Book=book;
        }
    }
}
