﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// Classe représentant les segments Vidéo que l'utilisateur enregistre via la web cam et modifie (trimming)
    /// via l'application
    /// </summary>
    public class VideoSequence : SegmentElement
    {

        public VideoSequence():
            base()
        {
        }

        public VideoSequence(VideoSequence oldVs)
            : base(oldVs)
        {
            Path = oldVs.Path;
            RunTime = oldVs.RunTime;
            BeginTrim = oldVs.BeginTrim;
            EndTrim = oldVs.EndTrim;
            
        }

        /// <summary>
        /// Chemin d'accès à la vidéo
        /// </summary>
        public String Path { get; set; }

        /// <summary>
        /// Temps de la video (Absolue - sans recadrage)
        /// </summary>
        public TimeSpan RunTime { get; set; }

        /// <summary>
        /// Recadrage à gauche (Débuter la vidéo plus tard)
        /// </summary>
        public TimeSpan BeginTrim { get; set; }

        /// <summary>
        /// Recadrage à droite (Finir la vidéo plus tôt
        /// </summary>
        public TimeSpan EndTrim { get; set; }

        /// <summary>
        /// Temps de la vidéo (Effectif - avec les recadrage)
        /// </summary>
        public new TimeSpan Duration
        {
            get
            {
                
                return RunTime - (BeginTrim + EndTrim);
            }

        }

        public new TimeSpan TimerOut
        {
            get
            {
                return TimerIn + Duration;
            }
        }

        static public List<VideoSequence> GetProductionVideo(XDocument xdoc)
        {
            List<VideoSequence> returnList = new List<VideoSequence>();
            foreach (XElement XVideo in xdoc.Root.Elements()) 
            {
              
               returnList.Add(
                   new VideoSequence()
                    {
                        Path =   XVideo.Attribute("mediafile").Value,
                        RunTime = TimeSpan.FromMilliseconds(double.Parse(XVideo.Attribute("dur").Value)),
                        BeginTrim = new TimeSpan(0, 0, 0),
                        EndTrim = new TimeSpan(0, 0, 0),
                    }
                );
            }
            return returnList;
        }


    }
}
