﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIBody
    {
        public List<IRIEnsemble> Ensembles;
        public List<IRILink> Links;
        public List<IRIMedia> Medias;
        public List<IRIDecoupage> Displays;

        public IRIBody()
        {
            Ensembles = new List<IRIEnsemble>();
            Links = new List<IRILink>();
            Medias = new List<IRIMedia>();
            Displays = new List<IRIDecoupage>();
        }

        public XElement XML
        {
            get
            {
                XElement temp = new XElement("body");

                XElement XEnsembles = new XElement("ensembles");
                foreach (IRIEnsemble ensemble in Ensembles)
                {
                    XEnsembles.Add(ensemble.XML);
                }
                temp.Add(XEnsembles);
                temp.Add(new XElement("links"));
                XElement XMedias = new XElement("medias");
                foreach (IRIMedia media in Medias)
                {
                    XMedias.Add(media.XML); 
                }
                temp.Add(XMedias);

                

                temp.Add(new XElement("display"));

                return temp;
            }
        }
    }
}
