﻿using SLExtensions.Input;

namespace Iri.Modernisation.BaseMVVM.Commands
{
       /// <summary>
    /// Commandes
    /// </summary>
    public static class Commands
    {    
     
        /// <summary>
        /// Commandes relatives au ConsultMenu
        /// </summary>
        public static class ConsultMenu
        {
            static ConsultMenu()
            {
              GetBook = new Command("GetBook");
              ClickBook = new Command("ClickBook");
            }
            public static Command GetBook
            {
                get;
                private set;
            }
            public static Command ClickBook
            {
                get;
                private set;
            }
            public static void Initialize()
            {
               
            }
       
        }
       
        /// <summary>
        /// Commandes relatives au PersonnalChutier
        /// </summary>
        public static class PersonnalChutier 
        {
            static PersonnalChutier()
            {
                //PersonnalChutier
                Search = new Command("Search");
                ClickAnnotation = new Command("ClickAnnotation");
            }
            public static Command Search
            {
                get;
                private set;
            }
            public static Command ClickAnnotation
            {
                get;
                private set;
            }
            public static void Initialize()
            {

            }
        }

        /// <summary>
        /// Commandes relatives au ReferencesChutier
        /// </summary>
        public static class ReferencesChutier
        {
            static ReferencesChutier()
            {
                //PersonnalChutier
                Search = new Command("iSearch");
                ClickAnnotation = new Command("iClickAnnotation");
                RefChutierAdd = new Command("RefChutierAdd");
            }
            public static Command RefChutierAdd
            {
                get;
                private set;
            }
            public static Command Search
            {
                get;
                private set;
            }
            public static Command ClickAnnotation
            {
                get;
                private set;
            }
            public static void Initialize()
            {

            }
        }
        
        /// <summary>
        /// Commandes relatives au AnnotationMaker
        /// </summary>
        public static class AnnotationMaker
        {
            static AnnotationMaker()
            {
                OkClick = new Command("OkClick");
                Play = new Command("Play");
                Pause = new Command("Pause");
                LeftTrim = new Command("LeftTrim");
                RightTrim = new Command("RightTrim");
                NewAnnotationFinished = new Command("NewAnnotationFinished");
            }

            public static Command NewAnnotationFinished
            {
                get;
                private set;
            }
            public static Command OkClick
            {
                get;
                private set;
            }
            public static Command Play
            {
                get;
                private set;
            }
            public static Command Pause
            {
                get;
                private set;
            }
            public static Command LeftTrim
            {
                get;
                private set;
            }
            public static Command RightTrim
            {
                get;
                private set;
            }
            public static void Initialize()
            { 
            }


        }

        /// <summary>
        /// Commandes relatives au ClickMenu
        /// </summary>
        public static class ClickMenu
        {
            static ClickMenu()
            {
                ActionReleased = new Command("ActionReleased");
                CreateNewTextualAnnotation = new Command("CreateNewTextualAnnotation");
                AddToRefChutier = new Command("AddToChutier");
            }
            static public Command AddToRefChutier
            {
                get;
                private set;
            }
            static public Command CreateNewTextualAnnotation
            {
                get;
                private set;
            }

            static public Command ActionReleased
            {
                get;
                private set;
            }
        }

        /// <summary>
        /// Commandes relatives au HeaderControl
        /// </summary>
        public static class HeaderControl
        {
            static HeaderControl()
            {
                ButtonClick = new Command("ButtonClick");
            }

            static public Command ButtonClick
            {
                get;
                private set;
            }
            public static void Initialize()
            {
             
            }

        }

        /// <summary>
        /// Commandes relatives au PolemicElement
        /// </summary>
        public static class PolemicElement
        {
            static PolemicElement()
            {
                ElementSelected = new Command("ElementSelected");
                SelectPolemicElement = new Command("SelectPolemicElement");
            }
            public static Command ElementSelected
            {
                get;
                private set;
            }
            public static Command SelectPolemicElement
            {
                get;
                private set;
            }

            public static void Initialize()
              {
                 }

        }

        /// <summary>
        /// Commandes relatives au ConsultationBookView
        /// </summary>
        public static class ConsultationBookView
        {
            static ConsultationBookView()
            {

            }

            public static Command Action
            {
                get;
                private set;
            }

        }
        
        /// <summary>
        /// Commandes relatives au ContextualBinderLayer
        /// </summary>
        public static class ContextualBinderLayer
        {
            static ContextualBinderLayer()
            {
                BeginBind = new Command("BeginBind");
                EndBind = new Command("EndBind");
                ActiveBind = new Command("InBind");
                DesactiveBind = new Command("ActiveBind");
                SelectBind = new Command("SelectBind");
                UnSelectBind = new Command("UnSelectBind");
            }
            public static Command SelectBind
            {
                get;
                private set;
            }
            public static Command UnSelectBind
            {
                get;
                private set;
            }
            public static Command ActiveBind
            {
                get;
                private set;
            }
            public static Command DesactiveBind
            {
                get;
                private set;
            }
            public static Command BeginBind
            {
                get;
                private set;
            }

            public static Command EndBind
            {
                get;
                private set;
            }
            public static void Initialize()
            {
            }
        }

        /// <summary>
        /// Commandes relatives au HeaderProduction
        /// </summary>
        public static class HeaderProduction
        {
            static HeaderProduction()
            {
              

                PublishClick = new Command("PublishClick");
                SaveClick = new Command("SaveClick");
                EditFinishedOk = new Command("EditFinishedOk");
                IndexFinishedOk = new Command("IndexFinishedOk");
                

            }
            public static Command EditFinishedOk
            {
                get;
                private set;
            }
            public static Command IndexFinishedOk
            {
                get;
                private set;
            }

            public static Command PublishClick
            {
                get;
                private set;
            }
            public static Command SaveClick
            {
                get;
                private set;
            }
            static public void Initialize()
            {}
        }

        /// <summary>
        /// Commandes relatives au ProductionTimeLine
        /// </summary>
        public static class ProductionTimeLine
        {
            static  ProductionTimeLine()
            {
                EditorPartSelected = new Command("EditorPartSelected");
                EditorPartFinished = new Command("EditorPartFinished");
                IndexSelected = new Command("IndexSelected");
            }
            public static Command IndexSelected
            {
                get;
                private set;
            }
            public static Command EditorPartSelected
            {
                get;
                private set;
            }
            public static Command EditorPartFinished
            {
                get;
                private set;
            }
            static public void Initialize()
            { }
        }

        /// <summary>
        /// Commandes relatives au VideoViewer
        /// </summary>
        public static class VideoViewer
        {
            static VideoViewer()
            {
                Play = new Command("PlayVideo");
                Pause = new Command("PauseVideo");
                Next = new Command("NextVideo");
                Previous = new Command("PreviousVideo");
                Record = new Command("RecordVideo");
                Close = new Command("CloseVideo");
                SendPosition = new Command("SendPosition");
            }
            public static Command SendPosition
            {
                get;
                private set;
            }
            public static Command Play
            {
                get;
                private set;
            }
            public static Command Pause
            {
                get;
                private set;
            }
            public static Command Next
            {
                get;
                private set;
            }
            public static Command Previous
            {
                get;
                private set;
            }
            public static Command Record
            {
                get;
                private set;
            }
            public static Command Close
            {
                get;
                private set;
            }

            static public void Initialize()
            {

            }
        }

        /// <summary>
        /// Constructeur
        /// </summary>
        static Commands()
        {
            Action = new Command("Action");
            TimeChange = new Command("TimeChange");
            FlipView = new Command("FlipView");
            GoToTime = new Command("GoToTime");
            ActivePart = new Command("ActivePart");
            EscapeKeyPressed = new Command("EscapeKeyPressed");
            HttpSenderResponse = new Command("HttpSenderResponse");
           // VideoPositionTimer.Tick += new EventHandler(Each_Tick);
           
           
        }

        public static Command HttpSenderResponse
        {
            get;
            private set;
        }
        public static Command EscapeKeyPressed
        {
            get;
            private set;
        }

        public static Command ActivePart
        {
            get;
            private set;
        }
        public static Command Action
        {
            get;
            private set;
        }

        public static Command FlipView
        {
            get;
            private set;
        }
    

        public static Command TimeChange
        {
            get;
            private set;
        }

        public static Command GoToTime
        {
            get;
            private set;
        }
        public static class WebCamControl
        {
            static WebCamControl()
            {
                CamRecordLanch = new Command("CamRecordLanch");
                CamRecordBegin = new Command("CamRecordBegin");
                CamRecordEnd = new Command("CamRecordEnd");
                CamRecordStop = new Command("CamRecordStop");
            }
            public static Command CamRecordStop
            {
                get;
                private set;
            }
            public static Command CamRecordLanch
            {
                get;
                private set;
            }
            public static Command CamRecordBegin
            {
                get;
                private set;
            }
            public static Command CamRecordEnd
            {
                get;
                private set;
            }
            public static void Initialize()
            {
            }
        }
        public static class ProductionView
        {
           
            static ProductionView()
            {
                ClickAddSelectedRecord = new Command("ClickAddSelectedRecord");
                VideoRecordUpdated = new Command("VideoRecordUpdated");
                DelVideoSequence = new Command("DelVideoSequence");
                ClickAddIndex = new Command("ClickAddIndex");

            }
            public static Command ClickAddIndex
            {
                get;
                private set;
            }
            public static Command DelVideoSequence
            {
                get;
                private set;
            }
            public static Command ClickAddSelectedRecord
            {
                get;
                private set;
            }
            public static Command VideoRecordUpdated
            {
                get;
                private set;
            }
            public static void Initialize()
            {
            }
        }

        public static class BookTimeLine
        {

            static BookTimeLine()
            {
                SaveAnnotations = new Command("SaveAnnotations");
        
            }
            public static Command SaveAnnotations
            {
                get;
                private set;
            }
            
            public static void Initialize()
            {
            }
        }

        /// <summary>
        /// Ensure static fields are initialized
        /// </summary>
        public static void Initialize()
        {
            ConsultMenu.Initialize();
            ReferencesChutier.Initialize();
            PersonnalChutier.Initialize();
            AnnotationMaker.Initialize();
            HeaderControl.Initialize();
            PolemicElement.Initialize();
            ContextualBinderLayer.Initialize();
            HeaderProduction.Initialize();
            ProductionTimeLine.Initialize();
            VideoViewer.Initialize();
            ProductionView.Initialize();
            Commands.WebCamControl.Initialize();
            BookTimeLine.Initialize();
            
        }
    }
}
