﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
using System.Threading;
using Iri.Modernisation.Data.LDTClass;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// Classe VideoLivre
    /// </summary>
    public class VideoBook
    {
        /// <summary>
        /// Titre du VideoLivre
        /// </summary>
        public String Title { get; set; }

        /// <summary>
        /// Auteur du VideoLivre
        /// </summary>
        public User Author { get; set; }

        /// <summary>
        /// Chapitre du VideoLivre
        /// </summary>
        public VideoChapter[] Chapters { get; set; }

        /// <summary>
        /// Durée du VideoLivre
        /// </summary>
        public TimeSpan Duration { get; set; }

        /// <summary>
        /// Chemin de la vidéo fini
        /// </summary>
        public String MediaPath { get; set; }

        /// <summary>
        /// Chemin du projet .ldt
        /// </summary>
        public String LdtPath { get; set; }

        /// <summary>
        /// Chemin du .iri
        /// </summary>
        public String IriPath { get; set; }

        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public VideoBook()
        {
            Chapters = new VideoChapter[FactoryVideoLivre.VideoChapterDescriptions.Length];
            for (int nbChapitre = 0; nbChapitre < FactoryVideoLivre.VideoChapterDescriptions.Length; nbChapitre++)
            {
                Chapters[nbChapitre] = new VideoChapter(this,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Id,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Title,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Color);

            }
         
        }

     
     
           
        
        
    }
    public class VideoBookLoaderHelper
    {
        private WebClient webclient;
        private List<VideoBook> returnVideoBookList;
        private int nbOfBook;
        public VideoBookLoaderHelper(String path)
        {
            nbOfBook = 0;
            returnVideoBookList = new List<VideoBook>();
            webclient = new WebClient();
            webclient.DownloadStringCompleted += new DownloadStringCompletedEventHandler(webclient_DownloadStringCompleted);
            webclient.DownloadStringAsync(new Uri(path,UriKind.RelativeOrAbsolute ));
        }

        void webclient_DownloadStringCompleted(object sender, DownloadStringCompletedEventArgs e)
        {
            XDocument XDoc = XDocument.Parse(e.Result);
            List<VideoBook> ListReturn = new List<VideoBook>();
           
            foreach (XElement XVideoBook in XDoc.Root.Elements())
            {
                Loader<VideoBook> LoaderVideoBook = new Loader<VideoBook>(LDTFileReader.ConvertToVideoBook);
                LoaderVideoBook.LoaderFinished += new EventHandler<LoaderEventArgs<VideoBook>>(LoaderVideoBook_LoaderFinished);

                LoaderVideoBook.Load(XVideoBook.Attribute("metafile").Value);

                nbOfBook++;

            }

        
        }

        void LoaderVideoBook_LoaderFinished(object sender, LoaderEventArgs<VideoBook> e)
        {
            e.CreatedObject.LdtPath = ((Loader<VideoBook>)sender).Path ;
            returnVideoBookList.Add(e.CreatedObject);
            if(returnVideoBookList.Count == nbOfBook)
            {
                if(LoaderFinished!=null)
                {
                    LoaderFinished(this,new LoaderEventArgs<List<VideoBook>>(returnVideoBookList));
                }
            }
        }
        public event EventHandler<LoaderEventArgs<List<VideoBook>>> LoaderFinished;
      
        
    }
    /// <summary>
    /// Comparateur pour Trier les livres
    /// </summary>
    public class VideoBookComparer : IComparer<VideoBook>
    {
        public int Compare(VideoBook x, VideoBook y)
        {
            return x.Title.CompareTo(y.Title);
        }
    }

}
