﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Threading;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// 
    /// </summary>
    public static class SettingsProject
    {
        /// <summary>
        /// Liste des vidéoLivre Disponible
        /// </summary>
        static public List<VideoBook> ListVideoBook { get; set; }

        static SettingsProject()
        {
        }
        /// <summary>
        /// (Télé)Chargement des données;
        /// </summary>
        /// <param name="configFileURI"></param>
        static public void Load(String configFileURI)
        {
            FactoryVideoLivre.Initialize();
            FactoryVideoLivre.FactoryReady += new EventHandler(FactoryVideoLivre_FactoryReady);
            FactoryVideoLivre.LoadXMLFile(configFileURI);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        static void FactoryVideoLivre_FactoryReady(object sender, EventArgs e)
        {
           
            VideoBookLoaderHelper LoaderVideoBook = new VideoBookLoaderHelper(FactoryVideoLivre.VideoBookListPath);
            LoaderVideoBook.LoaderFinished += new EventHandler<LoaderEventArgs<List<VideoBook>>>(LoaderVideoBook_LoaderFinished);
           
        }

       

        static void LoaderVideoBook_LoaderFinished(object sender, LoaderEventArgs<List<VideoBook>> e)
        {
            SettingsProject.ListVideoBook = e.CreatedObject;
            if (SettingsLoaded != null)
                SettingsLoaded(sender, e);
        }
        /// <summary>
        /// Evenement prévenant quand tout est pret
        /// </summary>
        static public event EventHandler SettingsLoaded;
    }
}
