﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class LDTFileReader
    {
        public static VideoBook ConvertToVideoBook(XDocument Path)
        {
            LDTFile _ldtFile = new LDTFile();
            _ldtFile.Load(Path);
            VideoBook _videoBook = new VideoBook();
            if (_ldtFile != null)
            {
                // Initialisation du VideoBook
                _videoBook = new VideoBook()
                {
                    Title = _ldtFile.Project.Title,
                    Author = new User()
                    {
                        UserName = _ldtFile.Project.User,
                        
                    },
                    Duration = new TimeSpan(),
                    IriPath = _ldtFile.Medias[0].Src,
                    LdtPath = Path.BaseUri,

                };

                // Initialisation des index
                foreach (LDTAnnotationsContent LDTAC in _ldtFile.Annotations)
                {
                    int count=0;
                    int decoupage = LDTAC.Content[2].Elements.Count/4;
                    int selectedChapter = 0;
                    foreach(LDTElement LDTE  in LDTAC.Content[2].Elements)
                    {
                       
                       
                        _videoBook.Chapters[selectedChapter].Index.Add(new SegmentIndex(_videoBook.Chapters[selectedChapter])
                        {
                            Id= LDTE.Id,
                            Title = LDTE.Title,
                            Description = LDTE.Abstract,
                            Tags = LDTE.Tags,
                            TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                            Duration = new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur),
                            
                        });
                        count++;
                        if (count % decoupage == 0)
                        {
                            selectedChapter++;
                            if (selectedChapter >= 4)
                            {
                                selectedChapter = 3;
                            }
                        }
                        
                       _videoBook.Duration =  _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur));
                    }
                    foreach (LDTElement LDTE in LDTAC.Content[3].Elements)
                    {
                        _videoBook.Chapters[0].Annotations.Add(new Annotation(_videoBook.Chapters[0])
                        {
                            Id = LDTE.Id,
                            Title = LDTE.Title,
                            Description = LDTE.Abstract,
                            Tags = LDTE.Tags,
                            TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                            Duration = new TimeSpan(0, 0, 0, 0, (int)(LDTE.Dur+5000)),
                            Type = FactoryVideoLivre.AnnotationDescriptions[0]
                        });
                       // _videoBook.Duration = _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)(LDTE.Dur)));
                    }
                      foreach (LDTElement LDTE in LDTAC.Content[1].Elements)
                      {
                          _videoBook.Chapters[0].Annotations.Add(new Annotation(_videoBook.Chapters[0])
                          {
                              Title = LDTE.Title,
                              Description = LDTE.Abstract,
                              Tags = LDTE.Tags,
                              TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                              Duration = new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur),
                              Type = FactoryVideoLivre.AnnotationDescriptions[1]
                          });
                         // _videoBook.Duration = _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur));
                      }

                }
                return _videoBook;
                // Initialisation des Annotations
                //Initialisation des Liens
            }
            else
            {
                throw new Exception("Fichier LDT Null");
            }

        }
    }
}
