﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Controls.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
namespace Iri.Modernisation.Controls.View
{
	public partial class HeaderProductionChapter : UserControl
	{




            
        public bool Selected
        {
            get { return (bool)GetValue(SelectedProperty); }
            set 
            { 
                SetValue(SelectedProperty, value);
                
            }

        }

        // Using a DependencyProperty as the backing store for Selected.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty SelectedProperty =
            DependencyProperty.Register("Selected", typeof(bool), typeof(HeaderProductionChapter), new PropertyMetadata(false));



		public HeaderProductionChapter()
		{
			// Required to initialize variables
			InitializeComponent();
			 EditionController.Text = Iri.Modernisation.Lang.LangResource.EditingLabel;
             IndexController.Text = Iri.Modernisation.Lang.LangResource.IndexingLabel;
            // Commands.ActivePart.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ActivePart_Executed);
             EditionController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(EditionController_HeaderProductionPartFinished);
             IndexController.HeaderProductionPartFinished += new EventHandler<HeaderProductionPartControlerEventArgs>(IndexController_HeaderProductionPartFinished);
        }

        void IndexController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            ((HeaderProductionChapterVM)DataContext).Indexing = true;
        }

        void EditionController_HeaderProductionPartFinished(object sender, HeaderProductionPartControlerEventArgs e)
        {
            ((HeaderProductionChapterVM)DataContext).Editing = true;
        }

        void ActivePart_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
          
                //IndexController.IsActive = true;
        }
	}
}