﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Data;
using SLExtensions.Input;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
using System.Collections.Generic;
using System.Linq;
using Iri.Modernisation.Controls.View;
using Iri.Modernisation.Data.LDTClass;
namespace Iri.Modernisation.Controls.ViewModel
{

    /// <summary>
    /// ViewModel du module d'annotation
    /// </summary>
    public class AnnotationMakerVM : BaseMVVM.ViewModel.ViewModel
    {
       
        private PolemicElement _refElement;
        /// <summary>
        /// Element référent
        /// </summary>
        public PolemicElement RefElement
        {
            get
            {
                return _refElement;
            }
            set
            {
                _refElement = value;
                if(value!=null)
                {
                _newAnnotation = new Annotation(((PolemicElement)value).Chapter);
                Title = String.Empty;
                Description = String.Empty;
                Tags = String.Empty;
                SelectedType = FactoryVideoLivre.AnnotationDescriptions[0];
                BasicRelation = new PolemicLink() { FromElement = ((PolemicElement)value), ToElement = _newAnnotation, Type = null};
                PolemicRelation = new PolemicLink();
                PolemicRelation.FromElement = _newAnnotation;
                Begin = ((PolemicElement)value).TimerIn.TotalMilliseconds;
                End = ((PolemicElement)value).TimerOut.TotalMilliseconds;
                }
                OnPropertyChanged(String.Empty);
                //OnPropertyChanged("RefElement");
                //OnPropertyChanged("IsControlEnable");
                
            }
        }

        /// <summary>
        /// Savoir si le module de liens est activé
        /// </summary>
        public bool IsBinderActive { get; set; }
        /// <summary>
        /// Liste des Tags Référants
        /// </summary>
        public List<String> RefTags
        {
            get
            {
                if (_refElement != null)
                {
                    return _refElement.Tags;
                }
                else
                {
                    return new List<String>();
                }
            }
        }

        /// <summary>
        /// Annotation créé
        /// </summary>
        private Annotation _newAnnotation;

        
        private TimeSpan _begin;
        /// <summary>
        /// Temps de début de l'annotation
        /// </summary>
        public double Begin 
        {
            get
            {
                return _begin.TotalMilliseconds;
            }
            set
            {
                _begin = TimeSpan.FromMilliseconds(value);
                _newAnnotation.TimerIn = TimeSpan.FromMilliseconds(value);
                OnPropertyChanged("Begin");
            }
        }

        
        private TimeSpan _end;
        /// <summary>
        /// Temps de fin de l'annotation
        /// </summary>
        public double End
        {
            get
            {
                return _end.TotalMilliseconds;
            }
            set
            {
                _end = TimeSpan.FromMilliseconds(value);
                _newAnnotation.TimerOut = TimeSpan.FromMilliseconds(value);
                OnPropertyChanged("End");
            }
        }

        private PolemicTypeDescription _selectedType;
        /// <summary>
        /// Convertion Rectange
        /// </summary>
        public PolemicTypeDescription SelectedType
        {
            get
            {
                return _selectedType;
            }
            set
            {
                _selectedType = value;
                OnPropertyChanged("SelectedType");
               // Type = (PolemicElementType)((Rectangle)_selectedType).Resources["PolemicType"];
            }
        }

        private String _title;
        /// <summary>
        /// Titre de l'annotation
        /// </summary>
        public String Title
        {
            get
            { return _title; }
            set
            {
                _title = value;
                _newAnnotation.Title = value;
                OnPropertyChanged("Title");
            }
        }

        private String _description;

        /// <summary>
        /// Description de l'annotation
        /// </summary>
        public String Description
        {
            get
            {
                return _description;
            }
            set
            {
                _description = value;
                _newAnnotation.Description = value;
                OnPropertyChanged("Description");
            }

        }

        /// <summary>
        /// Tags de l'annotation
        /// </summary>
        public List<String> _tags =new List<String>();
        /// <summary>
        /// Tags de l'annotation
        /// </summary>
        public String Tags
        {
            get
            {
                try
                {
                    return String.Join(",", _tags.ToArray());
                }
                catch 
                {
                    return String.Empty;
                }
            }
            set
            {
                String val = (String)value;
                _tags = val.Split(',').ToList();
                _newAnnotation.Tags = val.Split(',').ToList();
                OnPropertyChanged("Tags");
               
                
            }
        }

     
        private PolemicLink _basicRelation;
        /// <summary>
        /// Relation basique
        /// </summary>
        public PolemicLink BasicRelation
        {
            get
            {
                return _basicRelation;
            }
            set
            {
                _basicRelation = value;
                OnPropertyChanged("BasicRelation");
            }


        }

      
        private PolemicLink _polemicRelation;
        /// <summary>
        /// Relation polémique
        /// </summary>
        public PolemicLink PolemicRelation
        {
            get
            {

                return _polemicRelation;
            }
            set
            {
                _polemicRelation = value;
                OnPropertyChanged("PolemicRelation");
            }


        }

        /// <summary>
        /// Détermine si le control est activé ou non
        /// </summary>
        public bool IsControlEnable
        {
            get
            {
                return _refElement != null;
            }
        }

        /// <summary>
        /// Permet d'initialiser les commands;
        /// </summary>
        private void InitializeCommands()
        {
            Commands.ContextualBinderLayer.BeginBind.Executed += new EventHandler<ExecutedEventArgs>(BeginBind_Executed);
            Commands.ContextualBinderLayer.SelectBind.Executed += new EventHandler<ExecutedEventArgs>(SelectBind_Executed);
            Commands.ContextualBinderLayer.ActiveBind.Executed += new EventHandler<ExecutedEventArgs>(ActiveBind_Executed);
            Commands.ContextualBinderLayer.DesactiveBind.Executed += new EventHandler<ExecutedEventArgs>(DesactiveBind_Executed);
            Commands.AnnotationMaker.OkClick.Executed += new EventHandler<ExecutedEventArgs>(OkClickAnnotationMaker_Executed);
        }

        private void DesactiveBind_Executed(object sender, ExecutedEventArgs e)
        {
            IsBinderActive = false;
        }

        private void ActiveBind_Executed(object sender, ExecutedEventArgs e)
        {
            IsBinderActive = true;
        }

      

        private void SelectBind_Executed(object sender, ExecutedEventArgs e)
        {
            if (IsControlEnable && IsBinderActive )
            {
                PolemicRelation.ToElement = (PolemicElement)e.Source;
                OnPropertyChanged("PolemicRelation");
            }
                
        }

        private void BeginBind_Executed(object sender, ExecutedEventArgs e)
        {
            if (IsControlEnable)
            {
                PolemicRelation.Type = ((ContextualLinkBinder)e.Parameter).PolemicType;
                PolemicRelation.ToElement = null;
                OnPropertyChanged("PolemicRelation");
                
            }

        }

      

        private void OkClickAnnotationMaker_Executed(object sender, ExecutedEventArgs e)
        {
            LDTElement newAnnotation = new LDTElement();
            newAnnotation.Title = Title;
            newAnnotation.Abstract = Description;
            newAnnotation.Begin = Begin;
            newAnnotation.Dur = End - Begin;
            newAnnotation.Tags = _tags;
            
            newAnnotation.Color = int.Parse(_selectedType.Color.A.ToString() + _selectedType.Color.R.ToString() + _selectedType.Color.G.ToString() + _selectedType.Color.B.ToString());
           
            
            LDTFile newfile = new LDTFile()
            {
                Medias  = new List<LDTMedia>()
                {
                    new LDTMedia()
                    {
                        Src = _refElement.Chapter.Book.IriPath
                    }
                },
                Relations = new List<LDTRelation>()
                {
                    new LDTRelation()
                    {
                        IdElementFrom = _basicRelation.FromElement.Id,
                        IdElementTo = _basicRelation.ToElement.Id,
                        //Title = _basicRelation.Title
                    }
                },
                Annotations = new List<LDTAnnotationsContent>()
                {
                    new LDTAnnotationsContent()
                    {
                        Content = new List<LDTAnnotationsDecoupage>()
                        {
                            new LDTAnnotationsDecoupage()
                            {
                                Elements = new List<LDTElement>()
                                {
                                    newAnnotation
                                }
                            }
                        }
                    }
                }

            };
            if (this._polemicRelation.ToElement != null)
            {
                LDTRelation polemicRelation = new LDTRelation()
                {
                    IdElementFrom = _polemicRelation.FromElement.Id,
                    IdElementTo = _polemicRelation.ToElement.Id,
                    Title = _polemicRelation.Title
                };
                newfile.Relations.Add(polemicRelation);
            }
            MessageBox.Show(newfile.ToString());
            _refElement = null;
            OnPropertyChanged("IsControlEnable");
        }

        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public AnnotationMakerVM()
        {

            InitializeCommands();

        }

        /// <summary>
        /// Constructeur par référence
        /// </summary>
        /// <param name="refAParam">Element référant</param>
        public AnnotationMakerVM(PolemicElement refAParam)
        {
            RefElement = refAParam;
            _newAnnotation = new Annotation(RefElement.Chapter);
           
            _basicRelation = new PolemicLink() { FromElement = RefElement, ToElement = _newAnnotation, Type = null};
            _polemicRelation = new PolemicLink();
            PolemicRelation.FromElement = _newAnnotation;
            InitializeCommands();
            Begin = RefElement.TimerIn.TotalMilliseconds;
            End = RefElement.TimerOut.TotalMilliseconds;
        }


        public PolemicTypeDescription[] ListAnnotationDescription
        {
            get
            {
                return FactoryVideoLivre.AnnotationDescriptions;
            }
           
        }



    }
   
}
