﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// Classe VideoLivre
    /// </summary>
    public class VideoBook
    {
        /// <summary>
        /// Titre du VideoLivre
        /// </summary>
        public String Title { get; set; }

        /// <summary>
        /// Auteur du VideoLivre
        /// </summary>
        public User Author { get; set; }

        /// <summary>
        /// Chapitre du VideoLivre
        /// </summary>
        public VideoChapter[] Chapters { get; set; }

        /// <summary>
        /// Durée du VideoLivre
        /// </summary>
        public TimeSpan Duration { get; set; }

        /// <summary>
        /// Chemin de la vidéo fini
        /// </summary>
        public String MediaPath { get; set; }

        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public VideoBook()
        {
            Chapters = new VideoChapter[4];
            Chapters[0] = new VideoChapter(this, "Modernisation", VideoChapterType.Modernisation);
            Chapters[1] = new VideoChapter(this, "Modernité", VideoChapterType.Modernite);
            Chapters[2] = new VideoChapter(this, "Post-Modernité",VideoChapterType.Postmodernite);
            Chapters[3] = new VideoChapter(this, "Ouverture",VideoChapterType.Ouverture);
         
        }

        
    }

    /// <summary>
    /// Comparateur pour Trier les livres
    /// </summary>
    public class VideoBookComparer : IComparer<VideoBook>
    {
        public int Compare(VideoBook x, VideoBook y)
        {
            return x.Title.CompareTo(y.Title);
        }
    }
}
