﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using Iri.Modernisation.Data.LDTClass;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel de la ProductionTimeLine
    /// </summary>
    public class ProductionTimeLineVM : BaseMVVM.ViewModel.ViewModel
    {

        private bool _isIndexing;
       
        /// <summary>
        /// Mode Indexation
        /// </summary>
        public bool IsIndexing
        {
            get
            {
                return _isIndexing;
            }
            set
            {
                _isIndexing = value;
                OnPropertyChanged("IsIndexing");
            }
        }

        private VideoBook _newBook;
        private ObservableCollection<VideoSequence>[] _listVideoSequences;
       
        /// <summary>
        /// Ensembles des VideoSequences par Chapitre
        /// </summary>
        public ObservableCollection<VideoSequence>[] ListVideoSequences
        {
            get
            {
                return _listVideoSequences;
            }
            set
            {
                _listVideoSequences = value;
                OnPropertyChanged("ListVideoSequences");
            }
        }
        
        /// <summary>
        /// VideoSequences du Chapitre en cours
        /// </summary>
        public ObservableCollection<VideoSequence> SelectedVideoSequences
        {
            get
            {
                
                return _listVideoSequences[SelectedChapter];
            }
            set
            {
                _listVideoSequences[SelectedChapter] = value;
                //_newBook.Chapters[SelectedChapter].VideoSequences = value;
                OnPropertyChanged("SelectedVideoSequences");
            }
        }

        /// <summary>
        /// Durée Total du livre
        /// </summary>
        public TimeSpan TotalBookDuration
        {
            get
            {
                TimeSpan temp = TimeSpan.Zero;
                foreach (ObservableCollection<VideoSequence> Ocvs in _listVideoSequences)
                {
                    foreach (VideoSequence Vs in Ocvs)
                    {
                        temp += Vs.Duration;
                    }
                }
                return temp;
            }
        }

        /// <summary>
        /// Chapitres
        /// </summary>
        public VideoChapter[] Chapters
        {
            get
            {
                return _newBook.Chapters;
            }
          
        
        }

        /// <summary>
        /// Chapites Courant
        /// </summary>
        public VideoChapter SelectedBookChapter
        {
            get
            {
                return _newBook.Chapters[SelectedChapter];
            }
        }


        private VideoSequence _actualVideoSequence;
        /// <summary>
        /// VideoSequence en lecture sur le Master
        /// </summary>
        public VideoSequence ActualVideoSequence
        {
            get
            {
                return _actualVideoSequence;
            }
            set
            {
                _actualVideoSequence = value;
                OnPropertyChanged("ActualVideoSequence");
            }
        }

        /// <summary>
        /// Ensemble des VideoSequences 
        /// </summary>
        public List<VideoSequence> TimeLine
        {
            get
            {
                List<VideoSequence> _tmp = new List<VideoSequence>();
                TimeSpan temp = TimeSpan.Zero;
                foreach (ObservableCollection<VideoSequence> Ocvs in ListVideoSequences)
                {
                    foreach (VideoSequence Vs in Ocvs)
                    {

                        Vs.TimerIn = temp;
                        _tmp.Add(Vs);
                        temp += Vs.Duration;
                    
                    }
                }
                return _tmp;
            }
        }

        private int _selectedChapter=0;
        public int SelectedChapter
        {
            get
            {
                return _selectedChapter;
            }
            set
            {
                _selectedChapter = value;
                OnPropertyChanged("SelectedChapter");
            }
        }

        private VideoViewerVM _videoViewerVM;
        /// <summary>
        /// ViewModel du Master
        /// </summary>
        public VideoViewerVM ViewModelVideoViewer
        {
            get
            {
                return _videoViewerVM;
            }
            set
            {
                _videoViewerVM = value;
                OnPropertyChanged("ViewModelVideoViewer");
            }
        }

        private double _position;
        /// <summary>
        /// Position Actuelle de lecture
        /// </summary>
        public double Position
        {
            get
            {
                return _position;
            }
            set
            {
                _position = value;
             
                OnPropertyChanged("Position");
            }
        }

        private ObservableCollection<SegmentIndex>[] _listSegmentIndex;
        /// <summary>
        /// Ensemble des Index par Chapitre
        /// </summary>
        public ObservableCollection<SegmentIndex>[] ListIndex
        {
            get
            {
                return _listSegmentIndex;
            }
        }
        /// <summary>
        /// Index du Chapitre en cours
        /// </summary>
        public ObservableCollection<SegmentIndex> SelectedIndex
        {
            get
            {
                return _listSegmentIndex[SelectedChapter];
            }
            set
            {
                _listSegmentIndex[SelectedChapter] = value;
                //_newBook.Chapters[SelectedChapter].Index = value;
                OnPropertyChanged("SelectedIndex");
            }
        }

        private VideoChapterType _selectedChapterType;

        /// <summary>
        /// Chapitre en cours
        /// </summary>
        public VideoChapterType SelectedChapterType
        {
            get
            {
                return _selectedChapterType;
            }
            set
            {
                _selectedChapterType = value;
                OnPropertyChanged("SelectedChapterType");
            }
        }

        private void InitializeCommands()
        {
            #region Commands
            Commands.ProductionView.DelVideoSequence.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(DelVideoSequence_Executed);
            Commands.ProductionTimeLine.EditorPartSelected.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartSelected_Executed);
            Commands.ProductionTimeLine.EditorPartFinished.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartFinished_Executed);
            Commands.ProductionView.ClickAddIndex.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickAddIndex_Executed);
            Commands.TimeChange.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(TimeChange_Executed);
           #endregion


            #region VideoSequences CollectionChanged
            foreach (ObservableCollection<VideoSequence> Ocvs in _listVideoSequences)
            {
                Ocvs.CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            }
            #endregion

            #region SegmentIndex CollectionChanged
            foreach (ObservableCollection<SegmentIndex> Ocsi in _listSegmentIndex)
            {
                Ocsi.CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            }
            #endregion
        }

       
        public ProductionTimeLineVM()
        {
            _newBook = new VideoBook();
 
            _listVideoSequences = new ObservableCollection<VideoSequence>[FactoryVideoLivre.NumberOfChapters];
            _listSegmentIndex = new ObservableCollection<SegmentIndex>[FactoryVideoLivre.NumberOfChapters];

            for (int i = 0; i<FactoryVideoLivre.NumberOfChapters;i++ )
            {
                _listVideoSequences[i] = new ObservableCollection<VideoSequence>();
                _listSegmentIndex[i] = new ObservableCollection<SegmentIndex>();
            }
      
            
           // PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(ProductionTimeLineVM_PropertyChanged);
           // SelectedVideoSequences = new ObservableCollection<VideoSequence>();
           InitializeCommands();
        }

    
        private void TimeChange_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            double newValue = ((double)e.Parameter);
            if(e.Source == this)
            {
                if (ActualVideoSequence.TimerIn.TotalMilliseconds > newValue || ActualVideoSequence.TimerOut.TotalMilliseconds < newValue)
                {
                    foreach (VideoSequence Vs in TimeLine)
                    {
                        if (Vs.TimerIn.TotalMilliseconds <= newValue && Vs.TimerOut.TotalMilliseconds > newValue)
                        {
                            ActualVideoSequence = Vs;
                            ViewModelVideoViewer.Source = ActualVideoSequence.Path;                  
                            ViewModelVideoViewer.GoTo(TimeSpan.FromMilliseconds(newValue) - Vs.TimerIn +Vs.BeginTrim);

                        }
                    }
                }
                else
                {
                    ViewModelVideoViewer.GoTo(TimeSpan.FromMilliseconds(newValue) - ActualVideoSequence.TimerIn);
                }
                
               
            }
        }

        private void ClickAddIndex_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if(IsIndexing)
            {
                TimeSpan dur = TimeSpan.Zero;
                // Permet de créer un Index avec une durée calé sur les videos.
                foreach (VideoSequence Vs in SelectedVideoSequences)
                {
                    dur += Vs.Duration;
                }
                foreach (SegmentIndex Si in SelectedIndex)
                {
                    dur -= Si.Duration;
                }
                SelectedIndex.Add(new SegmentIndex(SelectedBookChapter) 
                { 
                    TimerIn = TimeSpan.Zero, 
                    TimerOut = dur,
                    Chapter = SelectedBookChapter
                });

            }
 
        }

        private void DelVideoSequence_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedVideoSequences.Remove(((CustomableVideoElementVM)e.Parameter).VideoSequence);
            OnPropertyChanged("TotalBookDuration");
        }

        private void SelectedVideoSequences_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            
            OnPropertyChanged("TotalBookDuration");
            Commands.ProductionView.VideoRecordUpdated.Execute();
        }

        private void EditorPartFinished_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedChapter = -1;
        }

        private void EditorPartSelected_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
           
            SelectedChapter = (int)((HeaderProductionEventArgs)e.Source).ChapterType;
            SelectedChapterType = ((HeaderProductionEventArgs)e.Source).ChapterType ;
            IsIndexing = ((HeaderProductionEventArgs)e.Source).IsIndexPart;
        }

        public event EventHandler<ProductionTimeLineVMEventArgs> SwitchVideo;

    }
    public class ProductionTimeLineVMEventArgs : EventArgs
    {
        public VideoSequence VideoSequence{get;set;}
        public TimeSpan BeginAt{get;set;}
        public ProductionTimeLineVMEventArgs(VideoSequence videoSequence,TimeSpan beginAt)
        {
            VideoSequence = videoSequence;
            BeginAt = beginAt;
        }
    }
}
