﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
using System.IO;
using System.Collections.Generic;
using System.Threading;
namespace Iri.Modernisation.Data.Models
{

    public interface ILoader
    {
        event EventHandler<LoaderEventArgs<ILoader>> LoaderFinished;
    }
    
    /// <summary>
    /// Classe permettant de charger un XML et de convertir son contenu en un type ReturnType désiré
    /// </summary>
    /// <typeparam name="ReturnType">Type Désiré</typeparam>
    public class Loader<ResultType> 
    {

        private AutoResetEvent Are { get; set; }

        public String Path { get; set; }
        /// <summary>
        /// WebClient qui permet de charger le XML distant
        /// </summary>
        public  WebClient xmlClient {get; private set;}
        /// <summary>
        /// Fonction permettant de transcrire le document XML en Type désiré
        /// </summary>
        private Func<XDocument, ResultType> ProcessFunction { get; set; }
      
        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="processFunction">Fonction de transtypage</param>
       public Loader(Func<XDocument,ResultType> processFunction)
        {
            ProcessFunction = processFunction;
            xmlClient = new WebClient();
        }

        /// <summary>
        /// Téléchargement des données 
        /// </summary>
        /// <param name="path">Chemin du fichier</param>
        public void Load(String path)
        {
            //Here it's working
            // Are.Set();
            this.Path = path;
            xmlClient.DownloadStringCompleted += new DownloadStringCompletedEventHandler(xmlClient_DownloadStringCompleted);
        
            xmlClient.DownloadStringAsync(new Uri(path,UriKind.RelativeOrAbsolute));
           
           
            //Here not
            //Are.Set();
          
          
        }
       
        /// <summary>
        /// Une fois le fichier télécharger, on commence le transtypage
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void xmlClient_DownloadStringCompleted(object sender, DownloadStringCompletedEventArgs e)
        {
         
            //On utilise la fonction donnée lors de la construction du Loader pour créer l'objet grâce au fichier XML
            ResultType result = ProcessFunction.Invoke(XDocument.Parse(e.Result));
            if (LoaderFinished != null)
            {
                //Une fois le Transtypage Fini, on lance l'évenement indiquant que le chargement est fini et donnant
                // en argument l'objet créé.

                LoaderFinished(this, new LoaderEventArgs<ResultType>(result));
             
               
            }
        }
        public void  Execute(Object sender)
        {
            Are = (AutoResetEvent)sender;
            Load(this.Path);
         
        }
        public event EventHandler<LoaderEventArgs<ResultType>> LoaderFinished;
      
       
    }
    public class LoaderEventArgs<ResultType> :  EventArgs
    {
        public ResultType CreatedObject { get; private set; }
        public AutoResetEvent Are { get; private set; }
        public LoaderEventArgs(ResultType createdObject)
        {
            CreatedObject = createdObject;
            Are = null;
        }
        public LoaderEventArgs(ResultType createdObject,AutoResetEvent are)
        {
            CreatedObject = createdObject;
            Are = are;

        }
    }

 
    
}
