﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Classe Abstraite pour les balises Content
    /// </summary>
    public abstract class LDTContent
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Id { get; set; }
        public LDTContent()
        { }
    }

    /// <summary>
    /// Classe Content issue des Annotations
    /// </summary>
    public class LDTAnnotationsContent : LDTContent
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Title { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Author { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Abstract { get; set; }
        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTAnnotationsDecoupage> Content { get; set; }

        public LDTAnnotationsContent(XElement e)
        {
            Content = new List<LDTAnnotationsDecoupage>();
            Id = e.Attribute("id").Value;
            Title = e.Attribute("title").Value;
            Author = e.Attribute("author").Value;
            Abstract = e.Attribute("abstract").Value;
            foreach (XElement Elem in e.Elements())
            {
                Content.Add(new LDTAnnotationsDecoupage(Elem));
            }
        }
        public LDTAnnotationsContent()
        {
            Id = String.Empty;
            Title = String.Empty;
            Author = String.Empty;
            Abstract = String.Empty;
            Content = new List<LDTAnnotationsDecoupage>();
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("content",
                    new XAttribute("id", Id),
                    new XAttribute("title",Title),
                    new XAttribute("author",Author),
                    new XAttribute("abstract",Abstract)
                    );

                foreach (LDTAnnotationsDecoupage LDTAD in Content)
                {
                    temp.Add(LDTAD.XML);
                }
                return temp;
            }
        }
    }

    /// <summary>
    /// Classe COntent issue des Displays
    /// </summary>
    public class LDTDisplaysContent : LDTContent
    {
        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTDisplaysDecoupage> Content { get; set; }

        public LDTDisplaysContent(XElement e)
        {
            Content = new List<LDTDisplaysDecoupage>();

            Id = e.Attribute("id").Value;
            foreach (XElement Elem in e.Elements())
            {
                Content.Add(new LDTDisplaysDecoupage(Elem));   
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("content",
                    new XAttribute("id",Id)
                    );

                foreach (LDTDisplaysDecoupage LDTDD in Content)
                {
                    temp.Add(LDTDD.XML);
                }
                return temp;
            }
        }

    }
}
