﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIVideo
    {
       // id="a12" q="MQ" begin="0" dur="239333" src="testauthor_testtitle/testauthor_testtitle.flv"
        public String Id { get; set; }
        public String Q { get; set; }
        public TimeSpan Begin { get; set; }
        public TimeSpan Dur { get; set; }
        public String Src { get; set; }

        public IRIVideo()
        {
            Id = String.Empty;
            Q = String.Empty;
            Begin = TimeSpan.Zero;
            Dur = TimeSpan.Zero;
            Src = String.Empty;
        }
        public IRIVideo(XElement elem)
        {
            Id = elem.Attribute("id").Value;
            Q = elem.Attribute("q").Value;
            Begin = TimeSpan.FromMilliseconds(double.Parse(elem.Attribute("begin").Value));
            Dur = TimeSpan.FromMilliseconds(double.Parse(elem.Attribute("dur").Value));
            Src = elem.Attribute("src").Value;
        }
        public XElement XML
        {
            get
            {
                return new XElement("video",
                    new XAttribute("id",Id),
                    new XAttribute("q",Q),
                    new XAttribute("begin",Begin.TotalMilliseconds),
                    new XAttribute("dur",Dur.TotalMilliseconds),
                    new XAttribute("src",Src));
            }
        }

    }
}
