﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIFile
    {
        public List<IRIMeta> Head { get; set; }
        public IRIBody Body { get; set; }
        public IRIFile()
        {
            Head = new List<IRIMeta>();
            Body = new IRIBody();
        }

        public XDocument XMLFile
        {
            get
            {
                return new XDocument(XML);

            }

        }

        public override String ToString()
        {
            return XML.ToString();
        }

        public XElement XML
        {
            get
            {

                XElement temp = new XElement("iri");

                XElement Xhead = new XElement("head");
                foreach (IRIMeta meta in Head)
                {
                    Xhead.Add(meta.XML);
                }
                temp.Add(Xhead);

                temp.Add(Body.XML);

              
                return temp;
            }
        }
        public static IRIFile FromXML(XDocument xdoc)
        {
            IRIFile returnFile = new IRIFile();
            foreach (XElement Elem in xdoc.Root.Element("head").Elements())
            {
                returnFile.Head.Add(new IRIMeta(Elem));
            }

            XElement XBody = xdoc.Root.Element("body");
            foreach (XElement Elem in XBody.Element("ensembles").Elements())
            {
                returnFile.Body.Ensembles.Add(new IRIEnsemble(Elem));
            }

            foreach (XElement Elem in XBody.Element("medias").Elements())
            {
                returnFile.Body.Medias.Add(new IRIMedia(Elem));
            }

            return returnFile;
        }

    }
}
