﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIElement
    {
        //<element id="elD_0" order="" prev="" next="" begin="0" dur="933" author="DDC - IRI" date="06/2006" title="plan 0" abstract="" src="testauthor_testtitle/thumbs/0_in.jpg"/>

        public String Id { get; set; }
        public int Order { get; set; }
        public DateTime Date { get; set; }
        public int Chapter { get; set; }
        public String Prev { get; set; }
        public String Next { get; set; }
        public TimeSpan Begin { get; set; }
        public TimeSpan Dur { get; set; }
        public String Author { get; set; }
        public String Title { get; set; }
        public String Abstract { get; set; }
        public String Src { get; set; }
        public List<String> Tags { get; set; }

        public IRIElement()
        {
            Id = String.Empty;
            Order = 0;
            Chapter = 0;
            Prev = String.Empty;
            Next = String.Empty;
            Begin = TimeSpan.Zero;
            Dur = TimeSpan.Zero;
            Author = String.Empty;
            Title = String.Empty;
            Abstract = String.Empty;
            Src = String.Empty;
            Tags = new List<string>();
        }
        public IRIElement(XElement elem)
        {
            Id = elem.Attribute("id").Value;
            Order = int.Parse(elem.Attribute("order").Value);
            Prev = elem.Attribute("prev").Value;
            Next = elem.Attribute("next").Value;
            Begin = TimeSpan.FromMilliseconds(double.Parse(elem.Attribute("begin").Value));
            Dur = TimeSpan.FromMilliseconds(double.Parse(elem.Attribute("dur").Value));
            Author = elem.Attribute("author").Value;
            Title = elem.Attribute("title").Value;
            Abstract = elem.Attribute("abstract").Value;
            Src = elem.Attribute("src").Value;
            if(elem.Element("tags")!=null)
            {
                foreach (XElement XTag in elem.Element("tags").Elements())
                {
                    Tags.Add(XTag.Value);
                }
            }
            if(elem.Element("chapter")!=null)
            {
                Chapter = int.Parse(elem.Element("chapter").Value);
            }
            if (elem.Element("date") != null)
            {
                Date = DateTime.Parse(elem.Element("date").Value);
            }
            else
            {
                Date = DateTime.Now;
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp =  new XElement("element",
                    new XAttribute("id",Id),
                    new XAttribute("order",Order),
                    new XAttribute("date",Date.ToString("dd/MM/yyyy")),
                    new XAttribute("chapter",Chapter),
                    new XAttribute("prev",Prev),
                    new XAttribute("next",Next),
                    new XAttribute("begin",Begin.TotalMilliseconds),
                    new XAttribute("dur",Dur.TotalMilliseconds),
                    new XAttribute("author",Author),
                    new XElement("title",Title),
                    new XElement("abstract", Abstract),
                    new XAttribute("src",Src)
                    );
                XElement Xtags = new XElement("tags");
                foreach (String tag in Tags)
                {
                    Xtags.Add(new XElement("tag", tag));
                }
                temp.Add(Xtags);


                return temp;
            }
        }
    }
}
