﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Data.LDTClass;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using System.Collections.ObjectModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel de ConsultationView
    /// </summary>
    public class ConsultationViewVM : BaseMVVM.ViewModel.ViewModel
    {
        
        private PolemicElement _selectedElement;
        /// <summary>
        /// PolemicElement sélectionné
        /// </summary>
        public PolemicElement SelectedElement
        {
            get
            {
                return _selectedElement;
            }
            set
            {
                _selectedElement = value;
                OnPropertyChanged("SelectedElement");
            }
        }

        private ObservableCollection<BookTimeLineVM> _selectedVideoBooks;
        /// <summary>
        /// Liste des Livres Sélectionnés
        /// </summary>
        public ObservableCollection<BookTimeLineVM> SelectedVideoBooks
        {
            get
            {

                return _selectedVideoBooks;
            }
            set
            {
                _selectedVideoBooks = value;
                OnPropertyChanged("SelectedVideoBooks");
            }
        }

        private int _selectedVideoBookIndex=-1;
        /// <summary>
        /// Index du livre sélectionné
        /// </summary>
        public int SelectedVideoBookIndex
        {
            get
            {
                return _selectedVideoBookIndex;
            }
            set
            {
                _selectedVideoBookIndex= value;
                OnPropertyChanged("SelectedVideoBookIndex");
                ConsultationBookViewContextMenu.SelectedBookVM = (_selectedVideoBooks[value]);
               
            }
        }

        private ConsultationBookViewVM _consultationBookViewContextMenu;
        /// <summary>
        /// ViewModel de ConsultationBook
        /// </summary>
        public ConsultationBookViewVM ConsultationBookViewContextMenu
        {
            get
            {
                return _consultationBookViewContextMenu;
            }
            set
            {
                _consultationBookViewContextMenu = value;
                OnPropertyChanged(null);
            }
        }
        /// <summary>
        /// Loader pour chargement à la volée des VideoLivres selectionnés
        /// </summary>
        private Loader<VideoBook> _loaderVideoBook { get; set; }

        private AnnotationMakerVM _annotationMakerVM;
        /// <summary>
        /// ViewModel de AnnotationMaker
        /// </summary>
        public AnnotationMakerVM ViewModelAnnotationMaker
        {
            get
            {
                return _annotationMakerVM;
            }
            set
            {
                _annotationMakerVM = value;
                OnPropertyChanged("ViewModelAnnotationMaker");
            }
        }

        private void InitializeCommands()
        {
            Commands.ConsultMenu.ClickBook.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickBook_Executed);
            Commands.PolemicElement.SelectPolemicElement.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(SelectPolemicElement_Executed);
            Commands.ClickMenu.CreateNewTextualAnnotation.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CreateNewTextualAnnotation_Executed);
        }
       
        /// <summary>
        /// Evenement lors d'un click sur un livre de la liste
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ClickBook_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {

            bool CanAdd = true;
            //On regarde si le VideoLivre qu'on à choisis n'est pas déjà dans la liste des VideoLivres sélectionné
            foreach (BookTimeLineVM BookTLVM in SelectedVideoBooks)
            {
                if (BookTLVM.SelectedBook.LdtPath == ((VideoBook)e.Parameter).LdtPath)
                {
                    CanAdd = false;
                }
            }
            if (CanAdd)
            {
                //Préparation du loader
                _loaderVideoBook = new Loader<VideoBook>(LDTFileReader.ConvertToVideoBook);
                _loaderVideoBook.LoaderFinished += new EventHandler<LoaderEventArgs<VideoBook>>(LoaderVideoBook_LoaderFinished);
                _loaderVideoBook.Load(((VideoBook)e.Parameter).LdtPath);
            }
            

        }

        /// <summary>
        /// Fonction une fois que le fichier .ldt à été chargé
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void LoaderVideoBook_LoaderFinished(object sender, LoaderEventArgs<VideoBook> e)
        {
            VideoBook addedVideoBook = e.CreatedObject;
            ///------- ///
            addedVideoBook.LdtPath = _loaderVideoBook.Path;
            ///-----------------///
            BookTimeLineVM temp = new BookTimeLineVM(addedVideoBook);
            temp.ViewModelVideoViewer = ConsultationBookViewContextMenu.ActualVideoSourceVM;
            SelectedVideoBooks.Add(temp);
            
        }

        
        private void CreateNewTextualAnnotation_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            ViewModelAnnotationMaker.RefElement=SelectedElement;
        }
        public ConsultationViewVM()
        {
            InitializeCommands();
            _consultationBookViewContextMenu = new ConsultationBookViewVM();
            ViewModelAnnotationMaker = new AnnotationMakerVM();
            SelectedVideoBooks = new SLExtensions.Collections.ObjectModel.ObservableCollection<BookTimeLineVM>();
        }

        private void SelectPolemicElement_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedElement= (PolemicElement)e.Parameter;
            try
            {
                ConsultationBookViewContextMenu.SelectedIndex = (SegmentIndex)SelectedElement;
            }
            catch
            {
            }
        }
    }
}
