﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Iri.Modernisation.Controls.View
{
    public enum ClickMenuItemOrientation { Up = 90, Down = 126 }
	public partial class ClickMenuItem : UserControl
	{
        
         public ImageSource ImageSource {
            get { return imgItem.Source; }
            set { imgItem.Source = value; }
        }

        public ClickMenuItemOrientation Orientation
        {
            get { return (ClickMenuItemOrientation)GetValue(OrientationProperty); }
            set { 
                SetValue(OrientationProperty, value);
                path78339.RenderTransform = new RotateTransform() {Angle=(double)value };
            }
        }

        // Using a DependencyProperty as the backing store for Orientation.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty OrientationProperty =
            DependencyProperty.Register("Orientation", typeof(ClickMenuItemOrientation), typeof(ClickMenuItem), new PropertyMetadata(ClickMenuItemOrientation.Up));





        public String Title { get; set; }
        
        public event EventHandler<ClickMenuItemHooverEventArgs> ClickMenuItemHooverSelected;
        public event EventHandler<ClickMenuItemSelectedEventArgs> ClickMenuItemSelected;
		public ClickMenuItem()
		{
			// Required to initialize variables
			InitializeComponent();
		}

		private void OnMouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
		{
            OnEnter();
         
		}

        private void OnEnter()
        {
            if (ClickMenuItemHooverSelected != null)
            {
                this.ClickMenuItemHooverSelected(this, new ClickMenuItemHooverEventArgs());
            }
        }

       

        private void UserControl_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (ClickMenuItemSelected != null)
            {
                this.ClickMenuItemSelected(this, new ClickMenuItemSelectedEventArgs());
            }
        }
		
	}
    public class ClickMenuItemSelectedEventArgs : EventArgs
    {
    }
    public class ClickMenuItemHooverEventArgs : EventArgs
    {
       
        public ClickMenuItemHooverEventArgs()
		{			
			
		}

      
    }
}