﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class VideoViewerVM : BaseMVVM.ViewModel.ViewModel
    {

        private String _source;
        public String Source
        {
            get
            {
                return _source;
            }
            set
            {
                _source = value;
               
                OnPropertyChanged(null);
            }
        }
        public Uri USource
        {
            get
            {
                if (Source != null)
                {
                    return new Uri(Source, UriKind.RelativeOrAbsolute);
                }
                else
                {
                    return null;
                }
            }

        }
        public String Info
        {
            get
            {
                return position + ":" + Source;
            }
            
        }
        private TimeSpan position = new TimeSpan(0,0,0);
        public TimeSpan Position
        {
            get
            {
                return position;
            }
            set
            {
                position = value;
                //OnPropertyChanged("Position");
               OnPropertyChanged("Info");
            
            }
        }
        public VideoViewerVM()
        {
            Commands.VideoViewer.SendPosition.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(SendPosition_Executed);
            //Commands.GoToTime.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(GoToTime_Executed);
        }

        void SendPosition_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            //Position = (TimeSpan)(e.Parameter);
        }

       

    }
}
